/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs.util;

import hudson.util.FormFieldValidator;
import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class ThresholdValidator
extends FormFieldValidator {
    private static final String MESSAGE = "Threshold must be an integer value greater or equal 0.";

    public ThresholdValidator(StaplerRequest request, StaplerResponse response) {
        super(request, response, false);
    }

    protected void check() throws IOException, ServletException {
        String value = this.request.getParameter("value");
        if (!StringUtils.isEmpty((String)value)) {
            try {
                int integer = Integer.valueOf(value);
                if (integer < 0) {
                    this.error(MESSAGE);
                }
            }
            catch (NumberFormatException exception) {
                this.error(MESSAGE);
            }
        }
    }
}

