/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs;

import hudson.model.AbstractBuild;
import hudson.plugins.findbugs.FindBugsResultAction;
import hudson.plugins.findbugs.Messages;
import hudson.plugins.findbugs.ResultSummary;
import hudson.plugins.findbugs.parser.Bug;
import hudson.plugins.findbugs.util.AnnotationsBuildResult;
import hudson.plugins.findbugs.util.ParserResult;
import hudson.plugins.findbugs.util.model.JavaProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindBugsResult
extends AnnotationsBuildResult {
    private static final long serialVersionUID = 2768250056765266658L;

    public FindBugsResult(AbstractBuild<?, ?> build, ParserResult result) {
        super(build, result);
    }

    public FindBugsResult(AbstractBuild<?, ?> build, ParserResult result, FindBugsResult previous) {
        super(build, result, previous);
    }

    public String getSummary() {
        return ResultSummary.createSummary(this);
    }

    public String getDetails() {
        String message = ResultSummary.createDeltaMessage(this);
        if (this.getNumberOfAnnotations() == 0 && this.getDelta() == 0) {
            return message + "<li>" + Messages.FindBugs_ResultAction_NoWarningsSince(this.getZeroWarningsSinceBuild()) + "</li>";
        }
        return message;
    }

    @Override
    protected String getSerializationFileName() {
        return "findbugs-warnings.xml";
    }

    public String getDisplayName() {
        return Messages.FindBugs_ProjectAction_Name();
    }

    @Override
    public JavaProject getPreviousResult() {
        FindBugsResultAction action = (FindBugsResultAction)this.getOwner().getAction(FindBugsResultAction.class);
        if (action.hasPreviousResultAction()) {
            return ((FindBugsResult)action.getPreviousResultAction().getResult()).getProject();
        }
        return null;
    }

    @Override
    public boolean hasPreviousResult() {
        return ((FindBugsResultAction)this.getOwner().getAction(FindBugsResultAction.class)).hasPreviousResultAction();
    }

    static {
        XSTREAM.alias("bug", Bug.class);
    }
}

