/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs.util;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.FilePath;
import hudson.maven.MavenBuild;
import hudson.maven.MavenBuildProxy;
import hudson.maven.MavenReporter;
import hudson.maven.MojoInfo;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.plugins.findbugs.util.AbortException;
import hudson.plugins.findbugs.util.HealthReportBuilder;
import hudson.plugins.findbugs.util.ParserResult;
import hudson.plugins.findbugs.util.TrendReportSize;
import hudson.plugins.findbugs.util.model.Priority;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HealthAwareMavenReporter
extends MavenReporter {
    private static final String DEFAULT_PRIORITY_THRESHOLD_LIMIT = "low";
    private static final long serialVersionUID = 3003791883748835331L;
    private final String threshold;
    private boolean thresholdEnabled;
    private int minimumAnnotations;
    private final String healthy;
    private final String unHealthy;
    private int healthyAnnotations;
    private int unHealthyAnnotations;
    private boolean healthyReportEnabled;
    private final String height;
    private final String pluginName;
    private String thresholdLimit;

    public HealthAwareMavenReporter(String threshold, String healthy, String unHealthy, String height, String thresholdLimit, String pluginName) {
        this.threshold = threshold;
        this.healthy = healthy;
        this.unHealthy = unHealthy;
        this.height = height;
        this.thresholdLimit = thresholdLimit;
        this.pluginName = "[" + pluginName + "] ";
        this.validateThreshold(threshold);
        this.validateHealthiness(healthy, unHealthy);
        if (StringUtils.isBlank((String)thresholdLimit)) {
            this.thresholdLimit = DEFAULT_PRIORITY_THRESHOLD_LIMIT;
        }
    }

    private void validateHealthiness(String healthyParameter, String unHealthyParameter) {
        if (!StringUtils.isEmpty((String)healthyParameter) && !StringUtils.isEmpty((String)unHealthyParameter)) {
            try {
                this.healthyAnnotations = Integer.valueOf(healthyParameter);
                this.unHealthyAnnotations = Integer.valueOf(unHealthyParameter);
                if (this.healthyAnnotations >= 0 && this.unHealthyAnnotations > this.healthyAnnotations) {
                    this.healthyReportEnabled = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void validateThreshold(String thresholdParameter) {
        if (!StringUtils.isEmpty((String)thresholdParameter)) {
            try {
                this.minimumAnnotations = Integer.valueOf(thresholdParameter);
                if (this.minimumAnnotations >= 0) {
                    this.thresholdEnabled = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @SuppressWarnings(value={"Se"})
    private Object readResolve() {
        if (this.thresholdLimit == null) {
            this.thresholdLimit = DEFAULT_PRIORITY_THRESHOLD_LIMIT;
        }
        return this;
    }

    public final boolean postExecute(MavenBuildProxy build, MavenProject pom, MojoInfo mojo, BuildListener listener, Throwable error) throws InterruptedException, IOException {
        if (!this.acceptGoal(mojo.getGoal())) {
            return true;
        }
        PrintStream logger = listener.getLogger();
        if (this.hasResultAction(build).booleanValue()) {
            this.log(logger, "Scipping maven reporter: there is already a result available.");
            return true;
        }
        try {
            ParserResult result = this.perform(build, pom, mojo, logger);
            build.execute((MavenBuildProxy.BuildCallable)new /* Unavailable Anonymous Inner Class!! */);
            this.evaluateBuildResult(build, logger, result);
        }
        catch (AbortException exception) {
            logger.println(exception.getMessage());
            build.setResult(Result.FAILURE);
            return false;
        }
        return true;
    }

    protected abstract boolean acceptGoal(String var1);

    protected abstract ParserResult perform(MavenBuildProxy var1, MavenProject var2, MojoInfo var3, PrintStream var4) throws InterruptedException, IOException;

    protected abstract void persistResult(ParserResult var1, MavenBuild var2);

    protected void log(PrintStream logger, String message) {
        logger.println(StringUtils.defaultString((String)this.pluginName) + message);
    }

    private void evaluateBuildResult(MavenBuildProxy build, PrintStream logger, ParserResult result) {
        int annotationCount = 0;
        for (Priority priority : this.getPriorities()) {
            int numberOfAnnotations = result.getNumberOfAnnotations(priority);
            this.log(logger, "A total of " + numberOfAnnotations + " annotations have been found for priority " + priority);
            annotationCount += numberOfAnnotations;
        }
        if (annotationCount > 0 && this.isThresholdEnabled() && annotationCount >= this.getMinimumAnnotations()) {
            build.setResult(Result.UNSTABLE);
        }
    }

    private Boolean hasResultAction(MavenBuildProxy build) throws IOException, InterruptedException {
        return (Boolean)build.execute((MavenBuildProxy.BuildCallable)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected abstract Class<? extends Action> getResultActionClass();

    protected FilePath getTargetPath(MavenProject pom) {
        return new FilePath(new FilePath(pom.getBasedir()), "target");
    }

    protected HealthReportBuilder createHealthBuilder(String reportSingleCount, String reportMultipleCount) {
        return new HealthReportBuilder(this.isThresholdEnabled(), this.getMinimumAnnotations(), this.isHealthyReportEnabled(), this.getHealthyAnnotations(), this.getUnHealthyAnnotations(), reportSingleCount, reportMultipleCount);
    }

    public boolean isThresholdEnabled() {
        return this.thresholdEnabled;
    }

    public String getThreshold() {
        return this.threshold;
    }

    public int getMinimumAnnotations() {
        return this.minimumAnnotations;
    }

    public boolean isHealthyReportEnabled() {
        return this.healthyReportEnabled;
    }

    public String getHealthy() {
        return this.healthy;
    }

    public int getHealthyAnnotations() {
        return this.healthyAnnotations;
    }

    public String getUnHealthy() {
        return this.unHealthy;
    }

    public int getUnHealthyAnnotations() {
        return this.unHealthyAnnotations;
    }

    public String getHeight() {
        return this.height;
    }

    public int getTrendHeight() {
        return new TrendReportSize(this.height).getHeight();
    }

    protected Collection<Priority> getPriorities() {
        ArrayList<Priority> priorities = new ArrayList<Priority>();
        priorities.add(Priority.HIGH);
        if ("normal".equals(this.thresholdLimit)) {
            priorities.add(Priority.NORMAL);
        }
        if (DEFAULT_PRIORITY_THRESHOLD_LIMIT.equals(this.thresholdLimit)) {
            priorities.add(Priority.NORMAL);
            priorities.add(Priority.LOW);
        }
        return priorities;
    }

    public String getThresholdLimit() {
        return this.thresholdLimit;
    }
}

