/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs.util.model;

import hudson.plugins.findbugs.util.model.AnnotationContainer;
import hudson.plugins.findbugs.util.model.FileAnnotation;
import hudson.plugins.findbugs.util.model.WorkspaceFile;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaPackage
extends AnnotationContainer {
    private static final long serialVersionUID = 4034932648975191723L;
    private final String name;
    private final Map<String, WorkspaceFile> fileMapping = new HashMap<String, WorkspaceFile>();

    public JavaPackage(String packageName) {
        this.name = packageName;
    }

    private Object readResolve() {
        this.rebuildPriorities();
        return this;
    }

    public String getName() {
        return this.name;
    }

    @Override
    protected void annotationAdded(FileAnnotation annotation) {
        String fileName = annotation.getFileName();
        if (!this.fileMapping.containsKey(fileName)) {
            this.fileMapping.put(fileName, new WorkspaceFile(fileName));
        }
        this.fileMapping.get(fileName).addAnnotation(annotation);
    }

    public Collection<WorkspaceFile> getFiles() {
        return Collections.unmodifiableCollection(this.fileMapping.values());
    }

    public WorkspaceFile getFile(String fileName) {
        WorkspaceFile file = this.fileMapping.get(fileName);
        if (file != null) {
            return file;
        }
        throw new NoSuchElementException("File not found: " + fileName);
    }
}

