// CHECKSTYLE:OFF

package hudson.plugins.findbugs;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;

@SuppressWarnings({
    "",
    "PMD"
})
public class Messages {

    private final static ResourceBundleHolder holder = new ResourceBundleHolder(Messages.class);

    /**
     *  1 fixed warning
     * 
     */
    public static String FindBugs_ResultAction_OneFixedWarning() {
        return holder.format("FindBugs.ResultAction.OneFixedWarning");
    }

    /**
     *  1 fixed warning
     * 
     */
    public static Localizable _FindBugs_ResultAction_OneFixedWarning() {
        return new Localizable(holder, "FindBugs.ResultAction.OneFixedWarning");
    }

    /**
     * {0} new warnings
     * 
     */
    public static String FindBugs_ResultAction_MultipleNewWarnings(Object arg1) {
        return holder.format("FindBugs.ResultAction.MultipleNewWarnings", arg1);
    }

    /**
     * {0} new warnings
     * 
     */
    public static Localizable _FindBugs_ResultAction_MultipleNewWarnings(Object arg1) {
        return new Localizable(holder, "FindBugs.ResultAction.MultipleNewWarnings", arg1);
    }

    /**
     * FindBugs Warnings
     * 
     */
    public static String FindBugs_ProjectAction_Name() {
        return holder.format("FindBugs.ProjectAction.Name");
    }

    /**
     * FindBugs Warnings
     * 
     */
    public static Localizable _FindBugs_ProjectAction_Name() {
        return new Localizable(holder, "FindBugs.ProjectAction.Name");
    }

    /**
     * Skipping FindBugs file {0} because we have no permission to read the file.
     * 
     */
    public static String FindBugs_FindBugsCollector_Error_NoPermission(Object arg1) {
        return holder.format("FindBugs.FindBugsCollector.Error.NoPermission", arg1);
    }

    /**
     * Skipping FindBugs file {0} because we have no permission to read the file.
     * 
     */
    public static Localizable _FindBugs_FindBugsCollector_Error_NoPermission(Object arg1) {
        return new Localizable(holder, "FindBugs.FindBugsCollector.Error.NoPermission", arg1);
    }

    /**
     *  1 new warning
     * 
     */
    public static String FindBugs_ResultAction_OneNewWarning() {
        return holder.format("FindBugs.ResultAction.OneNewWarning");
    }

    /**
     *  1 new warning
     * 
     */
    public static Localizable _FindBugs_ResultAction_OneNewWarning() {
        return new Localizable(holder, "FindBugs.ResultAction.OneNewWarning");
    }

    /**
     * No warnings since build {0}.
     * 
     */
    public static String FindBugs_ResultAction_NoWarningsSince(Object arg1) {
        return holder.format("FindBugs.ResultAction.NoWarningsSince", arg1);
    }

    /**
     * No warnings since build {0}.
     * 
     */
    public static Localizable _FindBugs_ResultAction_NoWarningsSince(Object arg1) {
        return new Localizable(holder, "FindBugs.ResultAction.NoWarningsSince", arg1);
    }

    /**
     * Skipping FindBugs file {0} because it''s empty.
     * 
     */
    public static String FindBugs_FindBugsCollector_Error_EmptyFile(Object arg1) {
        return holder.format("FindBugs.FindBugsCollector.Error.EmptyFile", arg1);
    }

    /**
     * Skipping FindBugs file {0} because it''s empty.
     * 
     */
    public static Localizable _FindBugs_FindBugsCollector_Error_EmptyFile(Object arg1) {
        return new Localizable(holder, "FindBugs.FindBugsCollector.Error.EmptyFile", arg1);
    }

    /**
     * in 1 FindBugs file.
     * 
     */
    public static String FindBugs_ResultAction_OneFile() {
        return holder.format("FindBugs.ResultAction.OneFile");
    }

    /**
     * in 1 FindBugs file.
     * 
     */
    public static Localizable _FindBugs_ResultAction_OneFile() {
        return new Localizable(holder, "FindBugs.ResultAction.OneFile");
    }

    /**
     * Still {0} days before reaching the previous zero warnings highscore.
     * 
     */
    public static String FindBugs_ResultAction_MultipleNoHighScore(Object arg1) {
        return holder.format("FindBugs.ResultAction.MultipleNoHighScore", arg1);
    }

    /**
     * Still {0} days before reaching the previous zero warnings highscore.
     * 
     */
    public static Localizable _FindBugs_ResultAction_MultipleNoHighScore(Object arg1) {
        return new Localizable(holder, "FindBugs.ResultAction.MultipleNoHighScore", arg1);
    }

    /**
     * New zero warnings highscore: no FindBugs warnings since {0} days!
     * 
     */
    public static String FindBugs_ResultAction_MultipleHighScore(Object arg1) {
        return holder.format("FindBugs.ResultAction.MultipleHighScore", arg1);
    }

    /**
     * New zero warnings highscore: no FindBugs warnings since {0} days!
     * 
     */
    public static Localizable _FindBugs_ResultAction_MultipleHighScore(Object arg1) {
        return new Localizable(holder, "FindBugs.ResultAction.MultipleHighScore", arg1);
    }

    /**
     * Publish FindBugs Analysis Results
     * 
     */
    public static String FindBugs_Publisher_Name() {
        return holder.format("FindBugs.Publisher.Name");
    }

    /**
     * Publish FindBugs Analysis Results
     * 
     */
    public static Localizable _FindBugs_Publisher_Name() {
        return new Localizable(holder, "FindBugs.Publisher.Name");
    }

    /**
     * FindBugs: 1 warning found.
     * 
     */
    public static String FindBugs_ResultAction_HealthReportSingleItem() {
        return holder.format("FindBugs.ResultAction.HealthReportSingleItem");
    }

    /**
     * FindBugs: 1 warning found.
     * 
     */
    public static Localizable _FindBugs_ResultAction_HealthReportSingleItem() {
        return new Localizable(holder, "FindBugs.ResultAction.HealthReportSingleItem");
    }

    /**
     * Still one day before reaching the previous zero warnings highscore.
     * 
     */
    public static String FindBugs_ResultAction_OneNoHighScore() {
        return holder.format("FindBugs.ResultAction.OneNoHighScore");
    }

    /**
     * Still one day before reaching the previous zero warnings highscore.
     * 
     */
    public static Localizable _FindBugs_ResultAction_OneNoHighScore() {
        return new Localizable(holder, "FindBugs.ResultAction.OneNoHighScore");
    }

    /**
     * New FindBugs Warnings
     * 
     */
    public static String FindBugs_NewWarnings_Detail_header() {
        return holder.format("FindBugs.NewWarnings.Detail.header");
    }

    /**
     * New FindBugs Warnings
     * 
     */
    public static Localizable _FindBugs_NewWarnings_Detail_header() {
        return new Localizable(holder, "FindBugs.NewWarnings.Detail.header");
    }

    /**
     *  1 warning
     * 
     */
    public static String FindBugs_ResultAction_OneWarning() {
        return holder.format("FindBugs.ResultAction.OneWarning");
    }

    /**
     *  1 warning
     * 
     */
    public static Localizable _FindBugs_ResultAction_OneWarning() {
        return new Localizable(holder, "FindBugs.ResultAction.OneWarning");
    }

    /**
     * in {0} FindBugs files.
     * 
     */
    public static String FindBugs_ResultAction_MultipleFiles(Object arg1) {
        return holder.format("FindBugs.ResultAction.MultipleFiles", arg1);
    }

    /**
     * in {0} FindBugs files.
     * 
     */
    public static Localizable _FindBugs_ResultAction_MultipleFiles(Object arg1) {
        return new Localizable(holder, "FindBugs.ResultAction.MultipleFiles", arg1);
    }

    /**
     * New zero warnings highscore: no FindBugs warnings since yesterday!
     * 
     */
    public static String FindBugs_ResultAction_OneHighScore() {
        return holder.format("FindBugs.ResultAction.OneHighScore");
    }

    /**
     * New zero warnings highscore: no FindBugs warnings since yesterday!
     * 
     */
    public static Localizable _FindBugs_ResultAction_OneHighScore() {
        return new Localizable(holder, "FindBugs.ResultAction.OneHighScore");
    }

    /**
     * FindBugs file {0} was either created with the out-dated version 1.1.1 of the maven-findbugs-plugin or you did not specify the correct results file (findbugsXml.xml and not findbugs.xml).
     * 
     */
    public static String FindBugs_FindBugsCollector_Error_OldMavenPlugin(Object arg1) {
        return holder.format("FindBugs.FindBugsCollector.Error.OldMavenPlugin", arg1);
    }

    /**
     * FindBugs file {0} was either created with the out-dated version 1.1.1 of the maven-findbugs-plugin or you did not specify the correct results file (findbugsXml.xml and not findbugs.xml).
     * 
     */
    public static Localizable _FindBugs_FindBugsCollector_Error_OldMavenPlugin(Object arg1) {
        return new Localizable(holder, "FindBugs.FindBugsCollector.Error.OldMavenPlugin", arg1);
    }

    /**
     * {0} warnings
     * 
     */
    public static String FindBugs_ResultAction_MultipleWarnings(Object arg1) {
        return holder.format("FindBugs.ResultAction.MultipleWarnings", arg1);
    }

    /**
     * {0} warnings
     * 
     */
    public static Localizable _FindBugs_ResultAction_MultipleWarnings(Object arg1) {
        return new Localizable(holder, "FindBugs.ResultAction.MultipleWarnings", arg1);
    }

    /**
     * Fixed FindBugs Warnings
     * 
     */
    public static String FindBugs_FixedWarnings_Detail_header() {
        return holder.format("FindBugs.FixedWarnings.Detail.header");
    }

    /**
     * Fixed FindBugs Warnings
     * 
     */
    public static Localizable _FindBugs_FixedWarnings_Detail_header() {
        return new Localizable(holder, "FindBugs.FixedWarnings.Detail.header");
    }

    /**
     * FindBugs Trend
     * 
     */
    public static String FindBugs_Trend_Name() {
        return holder.format("FindBugs.Trend.Name");
    }

    /**
     * FindBugs Trend
     * 
     */
    public static Localizable _FindBugs_Trend_Name() {
        return new Localizable(holder, "FindBugs.Trend.Name");
    }

    /**
     * No description available.
     * 
     */
    public static String FindBugs_Publisher_NoMessageFoundText() {
        return holder.format("FindBugs.Publisher.NoMessageFoundText");
    }

    /**
     * No description available.
     * 
     */
    public static Localizable _FindBugs_Publisher_NoMessageFoundText() {
        return new Localizable(holder, "FindBugs.Publisher.NoMessageFoundText");
    }

    /**
     * {0} fixed warnings
     * 
     */
    public static String FindBugs_ResultAction_MultipleFixedWarnings(Object arg1) {
        return holder.format("FindBugs.ResultAction.MultipleFixedWarnings", arg1);
    }

    /**
     * {0} fixed warnings
     * 
     */
    public static Localizable _FindBugs_ResultAction_MultipleFixedWarnings(Object arg1) {
        return new Localizable(holder, "FindBugs.ResultAction.MultipleFixedWarnings", arg1);
    }

    /**
     * FindBugs: %d warnings found (%d %s, %d %s, %d %s).
     * 
     */
    public static String FindBugs_ResultAction_HealthReportMultipleItem() {
        return holder.format("FindBugs.ResultAction.HealthReportMultipleItem");
    }

    /**
     * FindBugs: %d warnings found (%d %s, %d %s, %d %s).
     * 
     */
    public static Localizable _FindBugs_ResultAction_HealthReportMultipleItem() {
        return new Localizable(holder, "FindBugs.ResultAction.HealthReportMultipleItem");
    }

    /**
     * FindBugs Warnings
     * 
     */
    public static String FindBugs_Detail_header() {
        return holder.format("FindBugs.Detail.header");
    }

    /**
     * FindBugs Warnings
     * 
     */
    public static Localizable _FindBugs_Detail_header() {
        return new Localizable(holder, "FindBugs.Detail.header");
    }

    /**
     * Parsing of file {0} failed due to an exception:
     * 
     */
    public static String FindBugs_FindBugsCollector_Error_Exception(Object arg1) {
        return holder.format("FindBugs.FindBugsCollector.Error.Exception", arg1);
    }

    /**
     * Parsing of file {0} failed due to an exception:
     * 
     */
    public static Localizable _FindBugs_FindBugsCollector_Error_Exception(Object arg1) {
        return new Localizable(holder, "FindBugs.FindBugsCollector.Error.Exception", arg1);
    }

}
