/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs;

import hudson.plugins.findbugs.Messages;
import hudson.plugins.findbugs.Pattern;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.digester.Digester;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FindBugsMessages {
    private final Map<String, String> messages = new HashMap<String, String>();
    private final Map<String, String> shortMessages = new HashMap<String, String>();
    private static final FindBugsMessages INSTANCE = new FindBugsMessages();

    public static FindBugsMessages getInstance() {
        return INSTANCE;
    }

    public synchronized void initialize() throws IOException, SAXException {
        this.loadMessages("messages.xml");
        this.loadMessages("fb-contrib-messages.xml");
    }

    private void loadMessages(String fileName) throws IOException, SAXException {
        InputStream file = FindBugsMessages.class.getResourceAsStream(fileName);
        List<Pattern> patterns = this.parse(file);
        for (Pattern pattern : patterns) {
            this.messages.put(pattern.getType(), pattern.getDescription());
            this.shortMessages.put(pattern.getType(), pattern.getShortDescription());
        }
    }

    public List<Pattern> parse(InputStream file) throws IOException, SAXException {
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.setClassLoader(FindBugsMessages.class.getClassLoader());
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        digester.push(patterns);
        digester.addObjectCreate("*/BugPattern", Pattern.class);
        digester.addSetProperties("*/BugPattern");
        digester.addCallMethod("*/BugPattern/Details", "setDescription", 0);
        digester.addCallMethod("*/BugPattern/ShortDescription", "setShortDescription", 0);
        digester.addSetNext("*/BugPattern", "add");
        digester.parse(file);
        return patterns;
    }

    public String getMessage(String name) {
        return StringUtils.defaultIfEmpty((String)this.messages.get(name), (String)Messages.FindBugs_Publisher_NoMessageFoundText());
    }

    public String getShortMessage(String name) {
        return StringUtils.defaultIfEmpty((String)this.shortMessages.get(name), (String)Messages.FindBugs_Publisher_NoMessageFoundText());
    }

    private FindBugsMessages() {
    }
}

