/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs.parser;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.SourceFile;
import edu.umd.cs.findbugs.ba.SourceFinder;
import hudson.plugins.findbugs.FindBugsMessages;
import hudson.plugins.findbugs.parser.Bug;
import hudson.plugins.findbugs.parser.XmlBugInstance;
import hudson.plugins.findbugs.util.model.FileAnnotation;
import hudson.plugins.findbugs.util.model.LineRange;
import hudson.plugins.findbugs.util.model.Priority;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.digester.Digester;
import org.apache.commons.lang.StringUtils;
import org.dom4j.DocumentException;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeFindBugsParser {
    public Collection<FileAnnotation> parse(File file, Collection<String> sources, String moduleName) throws IOException, DocumentException, SAXException {
        Map<String, String> hashToMessageMapping = this.createHashToMessageMapping(new FileInputStream(file));
        return this.parse(new FileInputStream(file), sources, moduleName, hashToMessageMapping);
    }

    public Map<String, String> createHashToMessageMapping(InputStream file) throws SAXException, IOException {
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.setClassLoader(NativeFindBugsParser.class.getClassLoader());
        String rootXPath = "BugCollection/BugInstance";
        digester.addObjectCreate(rootXPath, XmlBugInstance.class);
        digester.addSetProperties(rootXPath);
        String fileXPath = rootXPath + "/LongMessage";
        digester.addCallMethod(fileXPath, "setMessage", 0);
        digester.addSetNext(rootXPath, "add", Object.class.getName());
        ArrayList bugs = new ArrayList();
        digester.push(bugs);
        digester.parse(file);
        HashMap<String, String> mapping = new HashMap<String, String>();
        for (XmlBugInstance bug : bugs) {
            mapping.put(bug.getInstanceHash(), bug.getMessage());
        }
        return mapping;
    }

    public Collection<FileAnnotation> parse(InputStream file, Collection<String> sources, String moduleName, Map<String, String> hashToMessageMapping) throws IOException, DocumentException {
        Project project = this.createMavenProject(sources);
        SortedBugCollection collection = new SortedBugCollection();
        collection.readXML(file, project);
        SourceFinder sourceFinder = new SourceFinder();
        sourceFinder.setSourceBaseList(project.getSourceDirList());
        String actualName = this.extractModuleName(moduleName, project);
        ArrayList<FileAnnotation> annotations = new ArrayList<FileAnnotation>();
        Collection bugs = collection.getCollection();
        for (BugInstance warning : bugs) {
            String fileName;
            SourceLineAnnotation sourceLine = warning.getPrimarySourceLineAnnotation();
            String message = warning.getMessage();
            if (message.contains("TEST: Unknown warning")) {
                message = FindBugsMessages.getInstance().getShortMessage(warning.getType());
            }
            Bug bug = new Bug(this.getPriority(warning), StringUtils.defaultIfEmpty((String)hashToMessageMapping.get(warning.getInstanceHash()), (String)message), warning.getBugPattern().getCategory(), warning.getType(), sourceLine.getStartLine(), sourceLine.getEndLine());
            bug.setInstanceHash(warning.getInstanceHash());
            Iterator annotationIterator = warning.annotationIterator();
            while (annotationIterator.hasNext()) {
                BugAnnotation bugAnnotation = (BugAnnotation)annotationIterator.next();
                if (!(bugAnnotation instanceof SourceLineAnnotation)) continue;
                SourceLineAnnotation annotation = (SourceLineAnnotation)bugAnnotation;
                bug.addLineRange(new LineRange(annotation.getStartLine(), annotation.getEndLine()));
            }
            try {
                SourceFile sourceFile = sourceFinder.findSourceFile(sourceLine);
                fileName = sourceFile.getFullFileName();
            }
            catch (IOException exception) {
                fileName = sourceLine.getPackageName().replace(".", "/") + "/" + sourceLine.getSourceFile();
            }
            bug.setFileName(fileName);
            bug.setPackageName(warning.getPrimaryClass().getPackageName());
            bug.setModuleName(actualName);
            annotations.add(bug);
        }
        return annotations;
    }

    private Priority getPriority(BugInstance warning) {
        switch (warning.getPriority()) {
            case 1: {
                return Priority.HIGH;
            }
            case 2: {
                return Priority.NORMAL;
            }
        }
        return Priority.LOW;
    }

    private String extractModuleName(String defaultName, Project project) {
        if (StringUtils.isBlank((String)project.getProjectName())) {
            return defaultName;
        }
        return project.getProjectName();
    }

    private Project createMavenProject(Collection<String> sources) {
        Project project = new Project();
        for (String sourceFolder : sources) {
            project.addSourceDir(sourceFolder);
        }
        return project;
    }

    static {
        DetectorFactoryCollection.rawInstance().setPluginList(new URL[0]);
    }
}

