/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs.util;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.FilePath;
import hudson.maven.MavenBuild;
import hudson.maven.MavenModule;
import hudson.model.AbstractBuild;
import hudson.model.HealthReport;
import hudson.model.HealthReportingAction;
import hudson.plugins.findbugs.util.BuildResult;
import hudson.plugins.findbugs.util.HealthReportBuilder;
import hudson.plugins.findbugs.util.ParserResult;
import hudson.plugins.findbugs.util.PluginDescriptor;
import hudson.plugins.findbugs.util.ResultAction;
import hudson.plugins.findbugs.util.ToolTipProvider;
import hudson.plugins.findbugs.util.model.AnnotationProvider;
import hudson.plugins.findbugs.util.model.Priority;
import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.data.category.CategoryDataset;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResultAction<T extends BuildResult>
implements StaplerProxy,
HealthReportingAction,
ToolTipProvider,
ResultAction<T> {
    private static final long serialVersionUID = -7201451538713818948L;
    private static final int WIDTH = 500;
    @SuppressWarnings(value={"Se"})
    private final AbstractBuild<?, ?> owner;
    private HealthReportBuilder healthReportBuilder;
    private T result;

    public AbstractResultAction(AbstractBuild<?, ?> owner, HealthReportBuilder healthReportBuilder, T result) {
        this(owner, healthReportBuilder);
        this.result = result;
    }

    public AbstractResultAction(AbstractBuild<?, ?> owner, HealthReportBuilder healthReportBuilder) {
        this.owner = owner;
        this.healthReportBuilder = healthReportBuilder;
    }

    protected abstract PluginDescriptor getDescriptor();

    public String getUrlName() {
        return this.getDescriptor().getPluginResultUrlName();
    }

    @Override
    public final HealthReportBuilder getHealthReportBuilder() {
        if (this.healthReportBuilder == null) {
            this.healthReportBuilder = new HealthReportBuilder();
        }
        return this.healthReportBuilder;
    }

    public final HealthReport getBuildHealth() {
        return this.healthReportBuilder.computeHealth((AnnotationProvider)this.getResult(), this.owner.getProject(), this.getDescriptor());
    }

    public final AbstractBuild<?, ?> getOwner() {
        return this.owner;
    }

    public final Object getTarget() {
        return this.getResult();
    }

    @Override
    public final T getResult() {
        return this.result;
    }

    @Override
    public final void setResult(T result) {
        this.result = result;
    }

    public String getIconFileName() {
        if (this.getResult().getNumberOfAnnotations() > 0) {
            return this.getDescriptor().getIconUrl();
        }
        return null;
    }

    @Override
    public final void doGraph(StaplerRequest request, StaplerResponse response, int height) throws IOException {
        if (ChartUtil.awtProblem) {
            response.sendRedirect2(request.getContextPath() + "/images/headless.png");
            return;
        }
        ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)this.createChart(request), (int)500, (int)height);
    }

    @Override
    public final void doGraphMap(StaplerRequest request, StaplerResponse response, int height) throws IOException {
        ChartUtil.generateClickableMap((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)this.createChart(request), (int)500, (int)height);
    }

    private JFreeChart createChart(StaplerRequest request) {
        String parameter = request.getParameter("useHealthBuilder");
        boolean useHealthBuilder = Boolean.valueOf(StringUtils.defaultIfEmpty((String)parameter, (String)"true"));
        return this.getHealthReportBuilder().createGraph(useHealthBuilder, this.getDescriptor().getPluginResultUrlName(), this.buildDataSet(useHealthBuilder), this);
    }

    protected CategoryDataset buildDataSet(boolean useHealthBuilder) {
        DataSetBuilder builder = new DataSetBuilder();
        for (AbstractResultAction<T> action = this; action != null; action = action.getPreviousBuild()) {
            List<Object> series;
            Object current = action.getResult();
            if (current == null) continue;
            if (useHealthBuilder && this.getHealthReportBuilder().isEnabled()) {
                series = this.getHealthReportBuilder().createSeries(current.getNumberOfAnnotations());
            } else {
                series = new ArrayList<Integer>();
                series.add(current.getNumberOfAnnotations(Priority.LOW));
                series.add(current.getNumberOfAnnotations(Priority.NORMAL));
                series.add(current.getNumberOfAnnotations(Priority.HIGH));
            }
            int level = 0;
            for (Integer n : series) {
                builder.add((Number)n, (Comparable)Integer.valueOf(level), (Comparable)new ChartUtil.NumberOnlyBuildLabel(action.getOwner()));
                ++level;
            }
        }
        return builder.build();
    }

    protected AbstractResultAction<T> getPreviousBuild() {
        AbstractResultAction action;
        AbstractBuild build = this.getOwner();
        do {
            if ((build = (AbstractBuild)build.getPreviousBuild()) != null) continue;
            return null;
        } while ((action = (AbstractResultAction)build.getAction(this.getClass())) == null);
        return action;
    }

    @Override
    public boolean hasPreviousResultAction() {
        return this.getPreviousBuild() != null;
    }

    protected ParserResult createAggregatedResult(Map<MavenModule, List<MavenBuild>> moduleBuilds) {
        ParserResult project = this.createResult();
        for (List<MavenBuild> builds : moduleBuilds.values()) {
            if (builds.isEmpty()) continue;
            this.addModule(project, builds);
        }
        return project;
    }

    protected ParserResult createResult() {
        return new ParserResult();
    }

    protected void addModule(ParserResult aggregatedResult, List<MavenBuild> builds) {
        MavenBuild mavenBuild = builds.get(0);
        AbstractResultAction action = (AbstractResultAction)mavenBuild.getAction(this.getClass());
        if (action != null) {
            aggregatedResult.addAnnotations(((BuildResult)action.getResult()).getAnnotations());
            aggregatedResult.addModules(((BuildResult)action.getResult()).getModules());
            FilePath filePath = new FilePath(new File(mavenBuild.getRootDir(), "workspace-files"));
            try {
                filePath.copyRecursiveTo("*.tmp", new FilePath(new File(this.getOwner().getRootDir(), "workspace-files")));
            }
            catch (IOException exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Can't copy workspace files: ", exception);
            }
            catch (InterruptedException exception) {
                // empty catch block
            }
        }
    }
}

