/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs;

import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.plugins.findbugs.FindBugsDescriptor;
import hudson.plugins.findbugs.FindBugsProjectAction;
import hudson.plugins.findbugs.FindBugsResult;
import hudson.plugins.findbugs.FindBugsResultAction;
import hudson.plugins.findbugs.FindBugsResultBuilder;
import hudson.plugins.findbugs.parser.FindBugsParser;
import hudson.plugins.findbugs.util.AnnotationParser;
import hudson.plugins.findbugs.util.FilesParser;
import hudson.plugins.findbugs.util.HealthAwarePublisher;
import hudson.plugins.findbugs.util.HealthDescriptor;
import hudson.plugins.findbugs.util.ParserResult;
import hudson.plugins.findbugs.util.PluginDescriptor;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindBugsPublisher
extends HealthAwarePublisher {
    private static final String DEFAULT_PATTERN = "**/findbugs.xml";
    public static final PluginDescriptor FIND_BUGS_DESCRIPTOR = new FindBugsDescriptor();
    private final String pattern;

    @DataBoundConstructor
    public FindBugsPublisher(String pattern, String threshold, String healthy, String unHealthy, String height, String thresholdLimit) {
        super(threshold, healthy, unHealthy, height, thresholdLimit, "FINDBUGS");
        this.pattern = pattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new FindBugsProjectAction(project, this.getTrendHeight());
    }

    public ParserResult perform(AbstractBuild<?, ?> build, PrintStream logger) throws InterruptedException, IOException {
        this.log(logger, "Collecting findbugs analysis files...");
        FilesParser collector = new FilesParser(logger, StringUtils.defaultIfEmpty((String)this.getPattern(), (String)DEFAULT_PATTERN), (AnnotationParser)new FindBugsParser(build.getProject().getWorkspace()), this.isMavenBuild(build), this.isAntBuild(build));
        ParserResult project = (ParserResult)build.getProject().getWorkspace().act((FilePath.FileCallable)collector);
        FindBugsResult result = new FindBugsResultBuilder().build(build, project);
        build.getActions().add(new FindBugsResultAction(build, (HealthDescriptor)this, result));
        return project;
    }

    public Descriptor<Publisher> getDescriptor() {
        return FIND_BUGS_DESCRIPTOR;
    }
}

