/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs;

import hudson.model.AbstractBuild;
import hudson.plugins.findbugs.PackageDetail;
import hudson.plugins.findbugs.util.AbstractAnnotationsDetail;
import hudson.plugins.findbugs.util.SourceDetail;
import hudson.plugins.findbugs.util.model.AnnotationProvider;
import hudson.plugins.findbugs.util.model.JavaPackage;
import hudson.plugins.findbugs.util.model.MavenModule;
import java.io.IOException;
import java.util.Collection;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleDetail
extends AbstractAnnotationsDetail {
    private static final long serialVersionUID = -1854984151887397361L;
    private final MavenModule module;

    public ModuleDetail(AbstractBuild<?, ?> owner, MavenModule module) {
        super(owner, module.getAnnotations());
        this.module = module;
    }

    public String getDisplayName() {
        return this.module.getName();
    }

    public MavenModule getModule() {
        return this.module;
    }

    public Collection<JavaPackage> getPackages() {
        return this.module.getPackages();
    }

    public boolean isSinglePackageModule() {
        return this.getPackages().size() == 1;
    }

    public final void doPackageStatistics(StaplerRequest request, StaplerResponse response) throws IOException {
        this.createDetailGraph(request, response, (AnnotationProvider)this.module.getPackage(request.getParameter("package")), this.module.getAnnotationBound());
    }

    public Object getDynamic(String link, StaplerRequest request, StaplerResponse response) {
        if (this.isSinglePackageModule()) {
            return new SourceDetail(this.getOwner(), this.getAnnotation(link));
        }
        return new PackageDetail(this.getOwner(), this.module.getPackage(link));
    }

    public String getToolTip(String packageName) {
        return this.module.getPackage(packageName).getToolTip();
    }
}

