/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs.parser;

import hudson.FilePath;
import hudson.plugins.findbugs.Messages;
import hudson.plugins.findbugs.parser.NativeFindBugsParser;
import hudson.plugins.findbugs.parser.maven.MavenFindBugsParser;
import hudson.plugins.findbugs.util.model.JavaProject;
import hudson.plugins.findbugs.util.model.MavenModule;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.dom4j.DocumentException;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class FindBugsCollector
implements FilePath.FileCallable<JavaProject> {
    private static final String SLASH = "/";
    private static final long serialVersionUID = -6415863872891783891L;
    private static final boolean SKIP_OLD_FILES = false;
    private transient PrintStream logger;
    private final long buildTime;
    private final String filePattern;

    public FindBugsCollector(PrintStream listener, long buildTime, String filePattern) {
        this.logger = listener;
        this.buildTime = buildTime;
        this.filePattern = filePattern;
    }

    public JavaProject invoke(File workspace, VirtualChannel channel) throws IOException {
        String[] findBugsFiles = this.findFindBugsFiles(workspace);
        JavaProject project = new JavaProject();
        if (findBugsFiles.length == 0) {
            project.setError("No findbugs report files were found. Configuration error?");
            return project;
        }
        try {
            for (String file : findBugsFiles) {
                String message;
                File findbugsFile = new File(workspace, file);
                String moduleName = FindBugsCollector.guessModuleName((String)findbugsFile.getAbsolutePath());
                MavenModule module = new MavenModule(moduleName);
                if (!findbugsFile.canRead()) {
                    message = Messages.FindBugs_FindBugsCollector_Error_NoPermission((Object)findbugsFile);
                    this.getLogger().println(message);
                    module.setError(message);
                    continue;
                }
                if (new FilePath(findbugsFile).length() <= 0L) {
                    message = Messages.FindBugs_FindBugsCollector_Error_EmptyFile((Object)findbugsFile);
                    this.getLogger().println(message);
                    module.setError(message);
                    continue;
                }
                module = this.parseFile(workspace, findbugsFile, module);
                project.addModule(module);
            }
        }
        catch (InterruptedException exception) {
            this.getLogger().println("Parsing has been canceled.");
        }
        return project;
    }

    private MavenModule parseFile(File workspace, File findbugsFile, MavenModule emptyModule) throws InterruptedException {
        Throwable exception = null;
        MavenModule module = emptyModule;
        try {
            FilePath filePath = new FilePath(findbugsFile);
            MavenFindBugsParser mavenFindBugsParser = new MavenFindBugsParser();
            if (mavenFindBugsParser.accepts(filePath.read())) {
                this.getLogger().println("Activating parser for maven-findbugs-plugin <= 1.1.1.");
                module = mavenFindBugsParser.parse(filePath.read(), emptyModule.getName(), workspace);
                module.setError(Messages.FindBugs_FindBugsCollector_Error_OldMavenPlugin((Object)findbugsFile));
            } else {
                this.getLogger().println("Activating parser for findbugs ant task, batch script, or maven-findbugs-plugin > 1.1.1.");
                NativeFindBugsParser parser = new NativeFindBugsParser();
                String moduleRoot = StringUtils.substringBefore((String)findbugsFile.getPath().replace('\\', '/'), (String)"/target/");
                module = parser.parse(filePath.read(), moduleRoot, emptyModule.getName());
            }
            this.getLogger().println("Successfully parsed findbugs file " + findbugsFile + " of module " + module.getName() + " with " + module.getNumberOfAnnotations() + " warnings.");
        }
        catch (IOException e) {
            exception = e;
        }
        catch (SAXException e) {
            exception = e;
        }
        catch (DocumentException e) {
            exception = e;
        }
        if (exception != null) {
            String errorMessage = Messages.FindBugs_FindBugsCollector_Error_Exception((Object)findbugsFile) + "\n\n" + ExceptionUtils.getStackTrace((Throwable)exception);
            this.getLogger().println(errorMessage);
            module.setError(errorMessage);
        }
        return module;
    }

    public static String guessModuleName(String fileName) {
        String separator = fileName.contains("/") ? "/" : "\\";
        String path = StringUtils.substringBefore((String)fileName, (String)(separator + "target"));
        if (fileName.equals(path)) {
            return "";
        }
        if (path.contains(separator)) {
            return StringUtils.substringAfterLast((String)path, (String)separator);
        }
        return path;
    }

    private String[] findFindBugsFiles(File workspaceRoot) {
        FileSet fileSet = new FileSet();
        Project project = new Project();
        fileSet.setProject(project);
        fileSet.setDir(workspaceRoot);
        fileSet.setIncludes(this.filePattern);
        return fileSet.getDirectoryScanner(project).getIncludedFiles();
    }

    private PrintStream getLogger() {
        if (this.logger == null) {
            this.logger = System.out;
        }
        return this.logger;
    }
}

