/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs.util.model;

import hudson.plugins.findbugs.util.model.AnnotationProvider;
import hudson.plugins.findbugs.util.model.FileAnnotation;
import hudson.plugins.findbugs.util.model.Priority;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationContainer
implements AnnotationProvider,
Serializable {
    private static final long serialVersionUID = 855696821788264261L;
    private final Map<Long, FileAnnotation> annotations = new HashMap();
    private transient Map<Priority, Set<FileAnnotation>> annotationsByPriority;

    public AnnotationContainer() {
        this.initializePrioritiesMap();
    }

    private void initializePrioritiesMap() {
        this.annotationsByPriority = new EnumMap(Priority.class);
        for (Priority priority : Priority.values()) {
            this.annotationsByPriority.put(priority, new HashSet());
        }
    }

    private Object readResolve() {
        this.rebuildPriorities();
        return this;
    }

    protected void rebuildPriorities() {
        this.initializePrioritiesMap();
        for (FileAnnotation annotation : this.getAnnotations()) {
            ((Set)this.annotationsByPriority.get(annotation.getPriority())).add(annotation);
        }
    }

    public final void addAnnotation(FileAnnotation annotation) {
        this.annotations.put(annotation.getKey(), annotation);
        ((Set)this.annotationsByPriority.get(annotation.getPriority())).add(annotation);
        this.annotationAdded(annotation);
    }

    public final void addAnnotations(Collection<? extends FileAnnotation> newAnnotations) {
        for (FileAnnotation fileAnnotation : newAnnotations) {
            this.addAnnotation(fileAnnotation);
        }
    }

    public final void addAnnotations(FileAnnotation[] newAnnotations) {
        this.addAnnotations(Arrays.asList(newAnnotations));
    }

    protected void annotationAdded(FileAnnotation annotation) {
    }

    public final Collection<FileAnnotation> getAnnotations() {
        return Collections.unmodifiableCollection(this.annotations.values());
    }

    public final Collection<FileAnnotation> getAnnotations(Priority priority) {
        return Collections.unmodifiableCollection((Collection)this.annotationsByPriority.get(priority));
    }

    public final Collection<FileAnnotation> getAnnotations(String priority) {
        return this.getAnnotations(this.getPriority(priority));
    }

    private Priority getPriority(String priority) {
        return Priority.fromString((String)priority);
    }

    public int getNumberOfAnnotations() {
        return this.annotations.size();
    }

    public int getNumberOfAnnotations(Priority priority) {
        return ((Set)this.annotationsByPriority.get(priority)).size();
    }

    public final int getNumberOfAnnotations(String priority) {
        return this.getNumberOfAnnotations(this.getPriority(priority));
    }

    public final boolean hasAnnotations() {
        return !this.annotations.isEmpty();
    }

    public final boolean hasAnnotations(Priority priority) {
        return !((Set)this.annotationsByPriority.get(priority)).isEmpty();
    }

    public final boolean hasAnnotations(String priority) {
        return this.hasAnnotations(this.getPriority(priority));
    }

    public final FileAnnotation getAnnotation(long key) {
        FileAnnotation annotation = (FileAnnotation)this.annotations.get(key);
        if (annotation != null) {
            return annotation;
        }
        throw new NoSuchElementException("Annotation not found: key=" + key);
    }

    public final FileAnnotation getAnnotation(String key) {
        return this.getAnnotation(Long.parseLong(key));
    }

    public String getToolTip() {
        StringBuilder message = new StringBuilder();
        for (Priority priority : Priority.values()) {
            if (!this.hasAnnotations(priority)) continue;
            message.append(priority.getLocalizedString());
            message.append(":");
            message.append(this.getNumberOfAnnotations(priority));
            message.append(" - ");
        }
        return StringUtils.removeEnd((String)message.toString(), (String)" - ");
    }
}

