/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.findbugs.FindBugsDescriptor;
import hudson.plugins.findbugs.FindBugsProjectAction;
import hudson.plugins.findbugs.FindBugsResult;
import hudson.plugins.findbugs.FindBugsResultAction;
import hudson.plugins.findbugs.Messages;
import hudson.plugins.findbugs.parser.FindBugsCollector;
import hudson.plugins.findbugs.util.AbortException;
import hudson.plugins.findbugs.util.HealthAwarePublisher;
import hudson.plugins.findbugs.util.HealthReportBuilder;
import hudson.plugins.findbugs.util.PluginDescriptor;
import hudson.plugins.findbugs.util.model.JavaProject;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindBugsPublisher
extends HealthAwarePublisher {
    private static final String DEFAULT_PATTERN = "**/findbugs.xml";
    public static final PluginDescriptor FIND_BUGS_DESCRIPTOR = new FindBugsDescriptor();

    public FindBugsPublisher(String pattern, String threshold, String healthy, String unHealthy) {
        super(pattern, threshold, healthy, unHealthy);
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new FindBugsProjectAction(project);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        PrintStream logger = listener.getLogger();
        try {
            logger.println("Collecting findbugs analysis files...");
            JavaProject project = this.parseAllWorkspaceFiles(build, logger);
            FindBugsResult result = this.createResult(build, project);
            HealthReportBuilder healthReportBuilder = this.createHealthReporter(Messages.FindBugs_ResultAction_HealthReportSingleItem(), Messages.FindBugs_ResultAction_HealthReportMultipleItem((Object)"%d"));
            build.getActions().add(new FindBugsResultAction(build, result, healthReportBuilder));
            this.evaluateBuildResult(build, logger, project);
            return true;
        }
        catch (AbortException exception) {
            logger.println(exception.getMessage());
            build.setResult(Result.FAILURE);
            return false;
        }
    }

    private void evaluateBuildResult(AbstractBuild<?, ?> build, PrintStream logger, JavaProject project) {
        int warnings = project.getNumberOfAnnotations();
        if (warnings > 0) {
            logger.println("A total of " + warnings + " potential bugs have been found.");
            if (this.isThresholdEnabled() && warnings >= this.getMinimumAnnotations()) {
                build.setResult(Result.UNSTABLE);
            }
        } else {
            logger.println("No potential bugs have been found.");
        }
    }

    private JavaProject parseAllWorkspaceFiles(AbstractBuild<?, ?> build, PrintStream logger) throws IOException, InterruptedException {
        FindBugsCollector findBugsCollector = new FindBugsCollector(logger, build.getTimestamp().getTimeInMillis(), StringUtils.defaultIfEmpty((String)this.getPattern(), (String)DEFAULT_PATTERN));
        return (JavaProject)build.getProject().getWorkspace().act((FilePath.FileCallable)findBugsCollector);
    }

    private FindBugsResult createResult(AbstractBuild<?, ?> build, JavaProject project) {
        AbstractBuild previousBuild;
        FindBugsResultAction previousAction;
        Run previous = build.getPreviousBuild();
        FindBugsResult result = previous instanceof AbstractBuild ? ((previousAction = (FindBugsResultAction)(previousBuild = (AbstractBuild)previous).getAction(FindBugsResultAction.class)) == null ? new FindBugsResult(build, project) : new FindBugsResult(build, project, ((FindBugsResult)previousAction.getResult()).getProject(), ((FindBugsResult)previousAction.getResult()).getZeroWarningsHighScore())) : new FindBugsResult(build, project);
        return result;
    }

    public Descriptor<Publisher> getDescriptor() {
        return FIND_BUGS_DESCRIPTOR;
    }
}

