/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs;

import com.thoughtworks.xstream.XStream;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.XmlFile;
import hudson.model.AbstractBuild;
import hudson.model.ModelObject;
import hudson.plugins.findbugs.FindBugsResultAction;
import hudson.plugins.findbugs.Messages;
import hudson.plugins.findbugs.ResultSummary;
import hudson.plugins.findbugs.parser.Bug;
import hudson.plugins.findbugs.util.AnnotationDifferencer;
import hudson.plugins.findbugs.util.ChartRenderer;
import hudson.plugins.findbugs.util.ErrorDetail;
import hudson.plugins.findbugs.util.FixedWarningsDetail;
import hudson.plugins.findbugs.util.ModuleDetail;
import hudson.plugins.findbugs.util.NewWarningsDetail;
import hudson.plugins.findbugs.util.PackageDetail;
import hudson.plugins.findbugs.util.PriorityDetailFactory;
import hudson.plugins.findbugs.util.SourceDetail;
import hudson.plugins.findbugs.util.model.AnnotationContainer;
import hudson.plugins.findbugs.util.model.AnnotationProvider;
import hudson.plugins.findbugs.util.model.AnnotationStream;
import hudson.plugins.findbugs.util.model.FileAnnotation;
import hudson.plugins.findbugs.util.model.JavaPackage;
import hudson.plugins.findbugs.util.model.JavaProject;
import hudson.plugins.findbugs.util.model.MavenModule;
import hudson.plugins.findbugs.util.model.Priority;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindBugsResult
implements ModelObject,
Serializable {
    private static final long serialVersionUID = 2768250056765266658L;
    private static final Logger LOGGER = Logger.getLogger(FindBugsResult.class.getName());
    private static final XStream XSTREAM = new AnnotationStream();
    @SuppressWarnings(value={"Se"})
    private transient WeakReference<JavaProject> project;
    @SuppressWarnings(value={"Se"})
    private transient WeakReference<Set<FileAnnotation>> newWarnings;
    @SuppressWarnings(value={"Se"})
    private transient WeakReference<Set<FileAnnotation>> fixedWarnings;
    private final int numberOfWarnings;
    private final int numberOfNewWarnings;
    private final int numberOfFixedWarnings;
    private final int delta;
    private final int low;
    private final int normal;
    private final int high;
    private int zeroWarningsSinceBuild;
    private long zeroWarningsSinceDate;
    private long zeroWarningsHighScore;
    private final List<String> errors;
    @SuppressWarnings(value={"Se"})
    private final AbstractBuild<?, ?> owner;
    private final Map<String, MavenModule> emptyModules;
    private final int numberOfModules;

    public FindBugsResult(AbstractBuild<?, ?> build, JavaProject project) {
        this(build, project, new JavaProject(), 0L);
    }

    public FindBugsResult(AbstractBuild<?, ?> build, JavaProject project, JavaProject previousProject, long highScore) {
        this.owner = build;
        this.numberOfWarnings = project.getNumberOfAnnotations();
        this.project = new WeakReference<JavaProject>(project);
        this.delta = project.getNumberOfAnnotations() - previousProject.getNumberOfAnnotations();
        Collection allWarnings = project.getAnnotations();
        Set warnings = AnnotationDifferencer.getNewWarnings((Collection)allWarnings, (Collection)previousProject.getAnnotations());
        this.numberOfNewWarnings = warnings.size();
        this.newWarnings = new WeakReference<Set>(warnings);
        warnings = AnnotationDifferencer.getFixedWarnings((Collection)allWarnings, (Collection)previousProject.getAnnotations());
        this.numberOfFixedWarnings = warnings.size();
        this.fixedWarnings = new WeakReference<Set>(warnings);
        this.high = project.getNumberOfAnnotations(Priority.HIGH);
        this.normal = project.getNumberOfAnnotations(Priority.NORMAL);
        this.low = project.getNumberOfAnnotations(Priority.LOW);
        this.emptyModules = new HashMap();
        for (MavenModule module : project.getModules()) {
            if (module.getNumberOfAnnotations() != 0) continue;
            this.emptyModules.put(module.getName(), module);
        }
        this.numberOfModules = project.getModules().size();
        this.errors = this.composeErrorMessage(project);
        if (this.numberOfWarnings == 0) {
            if (previousProject.getNumberOfAnnotations() != 0) {
                this.zeroWarningsSinceBuild = build.getNumber();
                this.zeroWarningsSinceDate = build.getTimestamp().getTimeInMillis();
            }
            this.zeroWarningsHighScore = Math.max(highScore, build.getTimestamp().getTimeInMillis() - this.zeroWarningsSinceDate);
        }
        try {
            Collection files = project.getAnnotations();
            this.getDataFile().write((Object)files.toArray(new FileAnnotation[files.size()]));
        }
        catch (IOException exception) {
            LOGGER.log(Level.WARNING, "Failed to serialize the findbugs result.", exception);
        }
    }

    private List<String> composeErrorMessage(JavaProject javaProject) {
        ArrayList<String> messages = new ArrayList<String>();
        if (javaProject.hasError()) {
            if (javaProject.getError() != null) {
                messages.add(javaProject.getError());
            }
            for (MavenModule module : javaProject.getModules()) {
                if (!module.hasError()) continue;
                messages.add(module.getError());
            }
        }
        return messages;
    }

    public String getSummary() {
        return ResultSummary.createSummary((FindBugsResult)this);
    }

    public String getDetails() {
        String message = ResultSummary.createDeltaMessage((FindBugsResult)this);
        if (this.numberOfWarnings == 0 && this.delta == 0) {
            return message + "<li>" + Messages.FindBugs_ResultAction_NoWarningsSince((Object)this.zeroWarningsSinceBuild) + "</li>";
        }
        return message;
    }

    public final boolean isCurrent() {
        return ((AbstractBuild)this.owner.getProject().getLastBuild()).number == this.owner.number;
    }

    public final AbstractBuild<?, ?> getOwner() {
        return this.owner;
    }

    public boolean hasError() {
        return !this.errors.isEmpty();
    }

    private XmlFile getDataFile() {
        return new XmlFile(XSTREAM, new File(this.getOwner().getRootDir(), "findbugs-warnings.xml"));
    }

    public int getNumberOfModules() {
        return this.numberOfModules;
    }

    public int getZeroWarningsSinceBuild() {
        return this.zeroWarningsSinceBuild;
    }

    public long getZeroWarningsSinceDate() {
        return this.zeroWarningsSinceDate;
    }

    public long getZeroWarningsHighScore() {
        return this.zeroWarningsHighScore;
    }

    public String getDisplayName() {
        return Messages.FindBugs_ProjectAction_Name();
    }

    public int getNumberOfAnnotations() {
        return this.numberOfWarnings;
    }

    public int getNumberOfAnnotations(Priority priority) {
        if (priority == Priority.HIGH) {
            return this.high;
        }
        if (priority == Priority.NORMAL) {
            return this.normal;
        }
        return this.low;
    }

    public final boolean hasAnnotations() {
        return this.getProject().hasAnnotations();
    }

    public Collection<FileAnnotation> getAnnotations() {
        return this.getProject().getAnnotations();
    }

    public int getNumberOfAnnotations(String priority) {
        return this.getNumberOfAnnotations(Priority.fromString((String)priority));
    }

    public int getNumberOfFixedWarnings() {
        return this.numberOfFixedWarnings;
    }

    public int getNumberOfNewWarnings() {
        return this.numberOfNewWarnings;
    }

    public int getDelta() {
        return this.delta;
    }

    public JavaProject getProject() {
        JavaProject result;
        if (this.project == null) {
            this.loadResult();
        }
        if ((result = (JavaProject)this.project.get()) == null) {
            this.loadResult();
        }
        return (JavaProject)this.project.get();
    }

    public Set<FileAnnotation> getNewWarnings() {
        Set result;
        if (this.newWarnings == null) {
            this.loadPreviousResult();
        }
        if ((result = (Set)this.newWarnings.get()) == null) {
            this.loadPreviousResult();
        }
        return (Set)this.newWarnings.get();
    }

    public Set<FileAnnotation> getFixedWarnings() {
        Set result;
        if (this.fixedWarnings == null) {
            this.loadPreviousResult();
        }
        if ((result = (Set)this.fixedWarnings.get()) == null) {
            this.loadPreviousResult();
        }
        return (Set)this.fixedWarnings.get();
    }

    private void loadResult() {
        JavaProject result;
        try {
            JavaProject newProject = new JavaProject();
            FileAnnotation[] annotations = (FileAnnotation[])this.getDataFile().read();
            newProject.addAnnotations(annotations);
            LOGGER.log(Level.INFO, "Loaded findbugs data file " + this.getDataFile() + " for build " + this.getOwner().getNumber());
            result = newProject;
        }
        catch (IOException exception) {
            LOGGER.log(Level.WARNING, "Failed to load " + this.getDataFile(), exception);
            result = new JavaProject();
        }
        this.project = new WeakReference<JavaProject>(result);
    }

    private void loadPreviousResult() {
        this.loadResult();
        this.newWarnings = this.hasPreviousResult() ? new WeakReference<Set>(AnnotationDifferencer.getNewWarnings((Collection)this.getProject().getAnnotations(), (Collection)this.getPreviousResult().getAnnotations())) : new WeakReference(new HashSet(this.getProject().getAnnotations()));
        this.fixedWarnings = this.hasPreviousResult() ? new WeakReference<Set>(AnnotationDifferencer.getFixedWarnings((Collection)this.getProject().getAnnotations(), (Collection)this.getPreviousResult().getAnnotations())) : new WeakReference<Set>(Collections.EMPTY_SET);
    }

    public Object getDynamic(String link, StaplerRequest request, StaplerResponse response) {
        PriorityDetailFactory factory = new PriorityDetailFactory();
        if (factory.isPriority(link)) {
            return factory.create(link, this.owner, (AnnotationContainer)this.getProject(), Messages.FindBugs_Detail_header());
        }
        if ("fixed".equals(link)) {
            return new FixedWarningsDetail(this.getOwner(), (Collection)this.getFixedWarnings(), Messages.FindBugs_FixedWarnings_Detail_header());
        }
        if ("new".equals(link)) {
            return new NewWarningsDetail(this.getOwner(), (Collection)this.getNewWarnings(), Messages.FindBugs_NewWarnings_Detail_header());
        }
        if ("error".equals(link)) {
            return new ErrorDetail(this.getOwner(), "FindBugs", this.errors);
        }
        if (this.isSingleModuleProject()) {
            if (this.isSinglePackageProject()) {
                return new SourceDetail(this.getOwner(), this.getProject().getAnnotation(link));
            }
            return new PackageDetail(this.getOwner(), ((MavenModule)this.getModules().iterator().next()).getPackage(link), Messages.FindBugs_Detail_header());
        }
        return new ModuleDetail(this.getOwner(), this.getModule(link), Messages.FindBugs_Detail_header());
    }

    private MavenModule getModule(String name) {
        MavenModule module = this.emptyModules.containsKey(name) ? (MavenModule)this.emptyModules.get(name) : this.getProject().getModule(name);
        return module;
    }

    public Collection<JavaPackage> getPackages() {
        return this.getProject().getPackages();
    }

    public Collection<MavenModule> getModules() {
        ArrayList<MavenModule> modules = new ArrayList<MavenModule>();
        modules.addAll(this.emptyModules.values());
        for (MavenModule module : this.getProject().getModules()) {
            if (this.emptyModules.containsKey(module.getName())) continue;
            modules.add(module);
        }
        return modules;
    }

    public boolean isSingleModuleProject() {
        return this.getNumberOfModules() == 1;
    }

    public boolean isSinglePackageProject() {
        return this.isSingleModuleProject() && this.getProject().getPackages().size() == 1;
    }

    public int getPreviousNumberOfWarnings(String packageName) {
        JavaProject previousResult = this.getPreviousResult();
        if (previousResult != null) {
            return previousResult.getPackage(packageName).getNumberOfAnnotations();
        }
        return 0;
    }

    public JavaProject getPreviousResult() {
        FindBugsResultAction action = (FindBugsResultAction)this.getOwner().getAction(FindBugsResultAction.class);
        if (action.hasPreviousResultAction()) {
            return ((FindBugsResult)action.getPreviousResultAction().getResult()).getProject();
        }
        return null;
    }

    public boolean hasPreviousResult() {
        return ((FindBugsResultAction)this.getOwner().getAction(FindBugsResultAction.class)).hasPreviousResultAction();
    }

    public final void doModuleStatistics(StaplerRequest request, StaplerResponse response) throws IOException {
        ChartRenderer.renderPriorititesChart((StaplerRequest)request, (StaplerResponse)response, (AnnotationProvider)this.getModule(request.getParameter("module")), (int)this.getProject().getAnnotationBound());
    }

    public final void doPackageStatistics(StaplerRequest request, StaplerResponse response) throws IOException {
        MavenModule module = (MavenModule)this.getModules().iterator().next();
        ChartRenderer.renderPriorititesChart((StaplerRequest)request, (StaplerResponse)response, (AnnotationProvider)module.getPackage(request.getParameter("package")), (int)module.getAnnotationBound());
    }

    public String getToolTip(String name) {
        if (this.isSingleModuleProject()) {
            return ((MavenModule)this.getModules().iterator().next()).getPackage(name).getToolTip();
        }
        return this.getModule(name).getToolTip();
    }

    public Priority[] getPriorities() {
        return Priority.values();
    }

    static {
        XSTREAM.alias("bug", Bug.class);
    }
}

