/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs.parser;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.SourceFile;
import edu.umd.cs.findbugs.ba.SourceFinder;
import hudson.plugins.findbugs.FindBugsResult;
import hudson.plugins.findbugs.parser.Bug;
import hudson.plugins.findbugs.util.model.LineRange;
import hudson.plugins.findbugs.util.model.MavenModule;
import hudson.plugins.findbugs.util.model.Priority;
import hudson.remoting.Which;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.dom4j.DocumentException;

public class NativeFindBugsParser {
    private static final Logger LOGGER = Logger.getLogger(FindBugsResult.class.getName());

    public MavenModule parse(InputStream file, String moduleRoot, String moduleName) throws IOException, DocumentException {
        Project project = this.createMavenProject(moduleRoot);
        SortedBugCollection collection = new SortedBugCollection();
        collection.readXML(file, project);
        SourceFinder sourceFinder = new SourceFinder();
        sourceFinder.setSourceBaseList(project.getSourceDirList());
        String actualName = this.extractModuleName(moduleName, project);
        MavenModule module = new MavenModule(actualName);
        Collection bugs = collection.getCollection();
        for (BugInstance warning : bugs) {
            String fileName;
            SourceLineAnnotation sourceLine = warning.getPrimarySourceLineAnnotation();
            Bug bug = new Bug(this.getPriority(warning), this.getMessage(warning), this.getCategory(warning), warning.getType(), sourceLine.getStartLine(), sourceLine.getEndLine(), warning.getBugPattern().getDetailText());
            Iterator annotationIterator = warning.annotationIterator();
            while (annotationIterator.hasNext()) {
                BugAnnotation bugAnnotation = (BugAnnotation)annotationIterator.next();
                if (!(bugAnnotation instanceof SourceLineAnnotation)) continue;
                SourceLineAnnotation annotation = (SourceLineAnnotation)bugAnnotation;
                bug.addLineRange(new LineRange(annotation.getStartLine(), annotation.getEndLine()));
            }
            try {
                SourceFile sourceFile = sourceFinder.findSourceFile(sourceLine);
                fileName = sourceFile.getFullFileName();
            }
            catch (IOException exception) {
                fileName = sourceLine.getPackageName().replace(".", "/") + "/" + sourceLine.getSourceFile();
            }
            bug.setFileName(fileName);
            bug.setPackageName(warning.getPrimaryClass().getPackageName());
            bug.setModuleName(actualName);
            module.addAnnotation(bug);
        }
        return module;
    }

    private String getMessage(BugInstance warning) {
        return warning.getMessage();
    }

    private Priority getPriority(BugInstance warning) {
        switch (warning.getPriority()) {
            case 1: {
                return Priority.HIGH;
            }
            case 2: {
                return Priority.NORMAL;
            }
        }
        return Priority.LOW;
    }

    private String extractModuleName(String defaultName, Project project) {
        if (StringUtils.isBlank((String)project.getProjectName())) {
            return defaultName;
        }
        return project.getProjectName();
    }

    private String getCategory(BugInstance warning) {
        BugPattern bugPattern = warning.getBugPattern();
        if (bugPattern == null) {
            return "Unknown";
        }
        return bugPattern.getCategory();
    }

    private static void initializeFindBugs() {
        try {
            String path = System.getProperty("hudson.plugins.findbugs.pluginpath");
            if (path != null) {
                String[] urlStrings = StringUtils.split((String)path, (String)";");
                URL[] urls = new URL[urlStrings.length];
                for (int i = 0; i < urlStrings.length; ++i) {
                    urls[i] = new URL(urlStrings[i]);
                }
                DetectorFactoryCollection.rawInstance().setPluginList(urls);
            } else {
                URL pluginPath = NativeFindBugsParser.getPluginPath();
                String original = pluginPath.toString().replace("\\", "/");
                String urlName = StringUtils.substringBeforeLast((String)original, (String)"/") + "/fbcontrib-3.4.2-hudson-1.jar";
                DetectorFactoryCollection.rawInstance().setPluginList(new URL[]{pluginPath, new URL(urlName)});
            }
        }
        catch (MalformedURLException exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    private static URL getPluginPath() throws MalformedURLException {
        try {
            return Which.jarFile(DetectorFactoryCollection.class).toURL();
        }
        catch (Exception exception) {
            return new URL("file://");
        }
    }

    private Project createMavenProject(String moduleRoot) {
        Project project = new Project();
        project.addSourceDir(moduleRoot + "/src/main/java");
        project.addSourceDir(moduleRoot + "/src/test/java");
        project.addSourceDir(moduleRoot + "/src");
        return project;
    }

    static {
        NativeFindBugsParser.initializeFindBugs();
    }
}

