/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs;

import hudson.maven.AggregatableAction;
import hudson.maven.MavenAggregatedReport;
import hudson.maven.MavenBuild;
import hudson.maven.MavenModuleSet;
import hudson.maven.MavenModuleSetBuild;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.plugins.findbugs.FindBugsProjectAction;
import hudson.plugins.findbugs.FindBugsResult;
import hudson.plugins.findbugs.FindBugsResultAction;
import hudson.plugins.findbugs.FindBugsResultBuilder;
import hudson.plugins.findbugs.util.HealthReportBuilder;
import hudson.plugins.findbugs.util.TrendReportSize;
import hudson.plugins.findbugs.util.model.AnnotationProvider;
import hudson.plugins.findbugs.util.model.JavaProject;
import hudson.plugins.findbugs.util.model.MavenModule;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenFindBugsResultAction
extends FindBugsResultAction
implements AggregatableAction,
MavenAggregatedReport {
    private static final long serialVersionUID = 1273798369273225973L;
    private final String height;

    public MavenFindBugsResultAction(MavenModuleSetBuild owner, HealthReportBuilder healthReportBuilder, String height) {
        super((AbstractBuild)owner, healthReportBuilder);
        this.height = height;
    }

    public MavenFindBugsResultAction(AbstractBuild<?, ?> owner, HealthReportBuilder healthReportBuilder, String height, FindBugsResult result) {
        super(owner, healthReportBuilder, result);
        this.height = height;
    }

    public MavenAggregatedReport createAggregatedAction(MavenModuleSetBuild build, Map<hudson.maven.MavenModule, List<MavenBuild>> moduleBuilds) {
        return new MavenFindBugsResultAction(build, this.getHealthReportBuilder(), this.height);
    }

    public Action getProjectAction(MavenModuleSet moduleSet) {
        return new FindBugsProjectAction((AbstractProject)moduleSet, new TrendReportSize(this.height).getHeight());
    }

    public Class<? extends AggregatableAction> getIndividualActionType() {
        return this.getClass();
    }

    public void update(Map<hudson.maven.MavenModule, List<MavenBuild>> moduleBuilds, MavenBuild newBuild) {
        JavaProject project = new JavaProject();
        for (List<MavenBuild> builds : moduleBuilds.values()) {
            if (builds.isEmpty()) continue;
            this.addModule(project, builds);
        }
        this.setResult((AnnotationProvider)new FindBugsResultBuilder().build(this.getOwner(), project));
    }

    private void addModule(JavaProject project, List<MavenBuild> builds) {
        MavenBuild mavenBuild = builds.get(0);
        MavenFindBugsResultAction action = (MavenFindBugsResultAction)mavenBuild.getAction(this.getClass());
        if (action != null) {
            Collection modules = ((FindBugsResult)action.getResult()).getProject().getModules();
            for (MavenModule mavenModule : modules) {
                project.addModule(mavenModule);
            }
        }
    }
}

