/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs.util;

import hudson.model.AbstractBuild;
import hudson.model.ModelObject;
import hudson.plugins.findbugs.util.AttributeDetail;
import hudson.plugins.findbugs.util.ChartBuilder;
import hudson.plugins.findbugs.util.ChartRenderer;
import hudson.plugins.findbugs.util.Messages;
import hudson.plugins.findbugs.util.ModuleDetail;
import hudson.plugins.findbugs.util.PackageDetail;
import hudson.plugins.findbugs.util.PriorityDetailFactory;
import hudson.plugins.findbugs.util.SourceDetail;
import hudson.plugins.findbugs.util.model.AnnotationContainer;
import hudson.plugins.findbugs.util.model.AnnotationProvider;
import hudson.plugins.findbugs.util.model.DefaultAnnotationContainer;
import hudson.plugins.findbugs.util.model.FileAnnotation;
import hudson.plugins.findbugs.util.model.JavaPackage;
import hudson.plugins.findbugs.util.model.MavenModule;
import hudson.plugins.findbugs.util.model.Priority;
import hudson.util.ChartUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jfree.chart.JFreeChart;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAnnotationsDetail
extends AnnotationContainer
implements ModelObject {
    private static final long serialVersionUID = 1750266351592937774L;
    private final AbstractBuild<?, ?> owner;

    public AbstractAnnotationsDetail(AbstractBuild<?, ?> owner, Collection<FileAnnotation> annotations, String name, AnnotationContainer.Hierarchy hierarchy) {
        super(name, hierarchy);
        this.owner = owner;
        this.addAnnotations(annotations);
    }

    public String getHeader() {
        return this.getName() + " - " + this.getDisplayName();
    }

    public final AbstractBuild<?, ?> getOwner() {
        return this.owner;
    }

    public final boolean isCurrent() {
        return ((AbstractBuild)this.owner.getProject().getLastBuild()).number == this.owner.number;
    }

    protected final void createDetailGraph(StaplerRequest request, StaplerResponse response, AnnotationProvider detailObject, int upperBound) throws IOException {
        if (ChartUtil.awtProblem) {
            response.sendRedirect2(request.getContextPath() + "/images/headless.png");
            return;
        }
        JFreeChart chart = ChartBuilder.createHighNormalLowChart(detailObject.getNumberOfAnnotations(Priority.HIGH), detailObject.getNumberOfAnnotations(Priority.NORMAL), detailObject.getNumberOfAnnotations(Priority.LOW), upperBound);
        ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)chart, (int)400, (int)20);
    }

    public String getLocalizedPriority(String priorityName) {
        return Priority.fromString(priorityName).getLongLocalizedString();
    }

    public final Object getDynamic(String link, StaplerRequest request, StaplerResponse response) {
        PriorityDetailFactory factory = new PriorityDetailFactory();
        if (factory.isPriority(link)) {
            return factory.create(link, this.owner, this, this.getDisplayName());
        }
        if (link.startsWith("module.")) {
            return new ModuleDetail(this.getOwner(), this.getModule(StringUtils.substringAfter((String)link, (String)"module.")), this.getDisplayName());
        }
        if (link.startsWith("package.")) {
            return new PackageDetail(this.getOwner(), this.getPackage(StringUtils.substringAfter((String)link, (String)"package.")), this.getDisplayName());
        }
        if (link.startsWith("source.")) {
            return new SourceDetail(this.getOwner(), this.getAnnotation(StringUtils.substringAfter((String)link, (String)"source.")));
        }
        if (link.startsWith("category.")) {
            String category = StringUtils.substringAfter((String)link, (String)"category.");
            return new AttributeDetail(this.getOwner(), this.getCategory(category), this.getDisplayName(), Messages.CategoryDetail_header() + " " + category);
        }
        if (link.startsWith("type.")) {
            String type = StringUtils.substringAfter((String)link, (String)"type.");
            return new AttributeDetail(this.getOwner(), this.getType(type), this.getDisplayName(), Messages.TypeDetail_header() + " " + type);
        }
        return null;
    }

    public final void doStatistics(StaplerRequest request, StaplerResponse response) throws IOException {
        String parameter = request.getParameter("object");
        if (parameter.startsWith("category.")) {
            Set<FileAnnotation> annotations = this.getCategory(StringUtils.substringAfter((String)parameter, (String)"category."));
            ChartRenderer.renderPriorititesChart(request, response, new DefaultAnnotationContainer(annotations), this.getAnnotationBound());
        } else if (parameter.startsWith("type.")) {
            Set<FileAnnotation> annotations = this.getType(StringUtils.substringAfter((String)parameter, (String)"type."));
            ChartRenderer.renderPriorititesChart(request, response, new DefaultAnnotationContainer(annotations), this.getAnnotationBound());
        } else if (parameter.startsWith("package.")) {
            JavaPackage annotations = this.getPackage(StringUtils.substringAfter((String)parameter, (String)"package."));
            ChartRenderer.renderPriorititesChart(request, response, annotations, this.getAnnotationBound());
        } else if (parameter.startsWith("module.")) {
            MavenModule annotations = this.getModule(StringUtils.substringAfter((String)parameter, (String)"module."));
            ChartRenderer.renderPriorititesChart(request, response, annotations, this.getAnnotationBound());
        }
    }

    public Priority[] getPriorities() {
        return Priority.values();
    }
}

