/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs.util;

import hudson.plugins.findbugs.util.ChartBuilder;
import hudson.plugins.findbugs.util.model.AnnotationContainer;
import hudson.plugins.findbugs.util.model.AnnotationProvider;
import hudson.plugins.findbugs.util.model.DefaultAnnotationContainer;
import hudson.plugins.findbugs.util.model.FileAnnotation;
import hudson.plugins.findbugs.util.model.JavaPackage;
import hudson.plugins.findbugs.util.model.Priority;
import hudson.plugins.findbugs.util.model.WorkspaceFile;
import hudson.util.ChartUtil;
import java.io.IOException;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jfree.chart.JFreeChart;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public final class ChartRenderer {
    public void doStatistics(StaplerRequest request, StaplerResponse response, AnnotationContainer container) throws IOException {
        String parameter = request.getParameter("object");
        if (parameter.startsWith("category.")) {
            Set<FileAnnotation> annotations = container.getCategory(StringUtils.substringAfter((String)parameter, (String)"category."));
            this.renderPriorititesChart(request, response, new DefaultAnnotationContainer(annotations), container.getAnnotationBound());
        } else if (parameter.startsWith("type.")) {
            Set<FileAnnotation> annotations = container.getType(StringUtils.substringAfter((String)parameter, (String)"type."));
            this.renderPriorititesChart(request, response, new DefaultAnnotationContainer(annotations), container.getAnnotationBound());
        } else if (parameter.startsWith("file.")) {
            WorkspaceFile annotations = container.getFile(Integer.valueOf(StringUtils.substringAfter((String)parameter, (String)"file.")));
            this.renderPriorititesChart(request, response, annotations, container.getAnnotationBound());
        } else if (parameter.startsWith("package.")) {
            JavaPackage annotations = container.getPackage(StringUtils.substringAfter((String)parameter, (String)"package."));
            this.renderPriorititesChart(request, response, annotations, container.getAnnotationBound());
        } else if (parameter.startsWith("module.")) {
            String moduleName = StringUtils.substringAfter((String)parameter, (String)"module.");
            AnnotationContainer annotations = container.containsModule(moduleName) ? container.getModule(moduleName) : new DefaultAnnotationContainer();
            this.renderPriorititesChart(request, response, annotations, container.getAnnotationBound());
        }
    }

    private void renderPriorititesChart(StaplerRequest request, StaplerResponse response, AnnotationProvider detailObject, int upperBound) throws IOException {
        if (ChartUtil.awtProblem) {
            response.sendRedirect2(request.getContextPath() + "/images/headless.png");
            return;
        }
        JFreeChart chart = ChartBuilder.createHighNormalLowChart(detailObject.getNumberOfAnnotations(Priority.HIGH), detailObject.getNumberOfAnnotations(Priority.NORMAL), detailObject.getNumberOfAnnotations(Priority.LOW), upperBound);
        ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)chart, (int)400, (int)20);
    }
}

