/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs.util;

import hudson.plugins.findbugs.util.AnnotationParser;
import hudson.plugins.findbugs.util.ContextHashCode;
import hudson.plugins.findbugs.util.model.FileAnnotation;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAnnotationParser
implements AnnotationParser {
    private static final long serialVersionUID = 4014720188570415914L;
    private final String defaultEncoding;

    protected AbstractAnnotationParser(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    protected final String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public Collection<FileAnnotation> parse(File file, String moduleName) throws InvocationTargetException {
        try {
            return this.parse((InputStream)new FileInputStream(file), moduleName);
        }
        catch (FileNotFoundException exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public abstract Collection<FileAnnotation> parse(InputStream var1, String var2) throws InvocationTargetException;

    protected int createContextHashCode(String fileName, int line) throws IOException {
        return new ContextHashCode().create(fileName, line, this.defaultEncoding);
    }
}

