/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs.util;

import hudson.plugins.findbugs.util.BuildResult;
import hudson.plugins.findbugs.util.GraphConfiguration;
import hudson.plugins.findbugs.util.ResultAction;
import hudson.util.ColorPalette;
import java.awt.Color;
import java.awt.Paint;
import java.util.Calendar;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYDifferenceRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleInsets;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BuildResultGraph {
    private String rootUrl = "";

    public void setRootUrl(String rootUrl) {
        this.rootUrl = rootUrl;
    }

    public String getRootUrl() {
        return this.rootUrl;
    }

    public abstract JFreeChart create(GraphConfiguration var1, ResultAction<? extends BuildResult> var2, String var3);

    protected long computeDayDelta(Calendar first, Calendar second) {
        return Math.abs((first.getTimeInMillis() - second.getTimeInMillis()) / 86400000L);
    }

    protected void setPlotProperties(Plot plot) {
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setForegroundAlpha(0.8f);
        plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 5.0));
    }

    public JFreeChart createXYChart(XYDataset dataset) {
        JFreeChart chart = ChartFactory.createXYAreaChart(null, null, (String)"count", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        XYPlot plot = chart.getXYPlot();
        plot.setRenderer((XYItemRenderer)new XYDifferenceRenderer((Paint)ColorPalette.BLUE, (Paint)ColorPalette.RED, false));
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        this.setPlotProperties((Plot)plot);
        return chart;
    }
}

