/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs;

import hudson.model.AbstractBuild;
import hudson.plugins.findbugs.FindBugsResultAction;
import hudson.plugins.findbugs.Messages;
import hudson.plugins.findbugs.ResultSummary;
import hudson.plugins.findbugs.parser.Bug;
import hudson.plugins.findbugs.util.AnnotationsBuildResult;
import hudson.plugins.findbugs.util.ParserResult;
import hudson.plugins.findbugs.util.model.JavaProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class FindBugsResult
extends AnnotationsBuildResult {
    private static final long serialVersionUID = 2768250056765266658L;

    public FindBugsResult(AbstractBuild<?, ?> build, String defaultEncoding, ParserResult result) {
        super(build, defaultEncoding, result);
    }

    public FindBugsResult(AbstractBuild<?, ?> build, String defaultEncoding, ParserResult result, FindBugsResult previous) {
        super(build, defaultEncoding, result, (AnnotationsBuildResult)previous);
    }

    public String getSummary() {
        return ResultSummary.createSummary((FindBugsResult)this);
    }

    public String getDetails() {
        String message = ResultSummary.createDeltaMessage((FindBugsResult)this);
        if (this.getNumberOfAnnotations() == 0 && this.getDelta() == 0) {
            message = message + "<li>" + Messages.FindBugs_ResultAction_NoWarningsSince((Object)this.getZeroWarningsSinceBuild()) + "</li>";
            message = message + this.createHighScoreMessage();
        }
        return message;
    }

    private String createHighScoreMessage() {
        if (this.isNewZeroWarningsHighScore()) {
            long days = FindBugsResult.getDays((long)this.getZeroWarningsHighScore());
            if (days == 1L) {
                return "<li>" + Messages.FindBugs_ResultAction_OneHighScore() + "</li>";
            }
            return "<li>" + Messages.FindBugs_ResultAction_MultipleHighScore((Object)days) + "</li>";
        }
        long days = FindBugsResult.getDays((long)this.getHighScoreGap());
        if (days == 1L) {
            return "<li>" + Messages.FindBugs_ResultAction_OneNoHighScore() + "</li>";
        }
        return "<li>" + Messages.FindBugs_ResultAction_MultipleNoHighScore((Object)days) + "</li>";
    }

    protected String getSerializationFileName() {
        return "findbugs-warnings.xml";
    }

    public String getDisplayName() {
        return Messages.FindBugs_ProjectAction_Name();
    }

    public JavaProject getPreviousResult() {
        FindBugsResultAction action = (FindBugsResultAction)this.getOwner().getAction(FindBugsResultAction.class);
        if (action.hasPreviousResultAction()) {
            return ((FindBugsResult)action.getPreviousResultAction().getResult()).getProject();
        }
        return null;
    }

    public boolean hasPreviousResult() {
        return ((FindBugsResultAction)this.getOwner().getAction(FindBugsResultAction.class)).hasPreviousResultAction();
    }

    static {
        XSTREAM.alias("bug", Bug.class);
    }
}

