/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs.util;

import hudson.plugins.findbugs.util.model.FileAnnotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public final class AnnotationDifferencer {
    public static Set<FileAnnotation> getNewAnnotations(Collection<FileAnnotation> actual, Collection<FileAnnotation> previous) {
        return AnnotationDifferencer.removeDuplicates((Set)AnnotationDifferencer.difference(actual, previous), (Set)AnnotationDifferencer.difference(previous, actual));
    }

    private static Set<FileAnnotation> difference(Collection<FileAnnotation> target, Collection<FileAnnotation> other) {
        HashSet<FileAnnotation> difference = new HashSet<FileAnnotation>(target);
        difference.removeAll(other);
        return difference;
    }

    private static Set<FileAnnotation> removeDuplicates(Set<FileAnnotation> targetSet, Set<FileAnnotation> otherSet) {
        HashSet otherHashCodes = AnnotationDifferencer.extractHashCodes(otherSet);
        ArrayList<FileAnnotation> duplicates = new ArrayList<FileAnnotation>();
        for (FileAnnotation annotation : targetSet) {
            if (!otherHashCodes.contains(annotation.getContextHashCode())) continue;
            duplicates.add(annotation);
        }
        targetSet.removeAll(duplicates);
        return targetSet;
    }

    private static HashSet<Long> extractHashCodes(Set<FileAnnotation> annotations) {
        HashSet<Long> hashCodes = new HashSet<Long>();
        for (FileAnnotation annotation : annotations) {
            hashCodes.add(annotation.getContextHashCode());
        }
        return hashCodes;
    }

    public static Set<FileAnnotation> getFixedAnnotations(Collection<FileAnnotation> actual, Collection<FileAnnotation> previous) {
        return AnnotationDifferencer.removeDuplicates((Set)AnnotationDifferencer.difference(previous, actual), (Set)AnnotationDifferencer.difference(actual, previous));
    }

    private AnnotationDifferencer() {
    }
}

