/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs.util.model;

import hudson.model.AbstractBuild;
import hudson.plugins.findbugs.util.model.FileAnnotation;
import hudson.plugins.findbugs.util.model.LineRange;
import hudson.plugins.findbugs.util.model.Priority;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAnnotation
implements FileAnnotation,
Serializable {
    public static final String WORKSPACE_FILES = "workspace-files";
    private static final long serialVersionUID = -1092014926477547148L;
    private static long currentKey;
    private final String message;
    private Priority priority;
    private final long key;
    private final List<LineRange> lineRanges;
    private final int primaryLineNumber;
    private String fileName;
    private String moduleName;
    private String packageName;
    private final String category;
    private final String type;
    private long contextHashCode;

    public AbstractAnnotation(String message, int start, int end, String category, String type) {
        this.message = StringUtils.strip((String)message);
        this.category = StringUtils.defaultString((String)category);
        this.type = StringUtils.defaultString((String)type);
        this.key = currentKey++;
        this.lineRanges = new ArrayList();
        this.lineRanges.add(new LineRange(start, end));
        this.primaryLineNumber = start;
        this.contextHashCode = currentKey;
    }

    public AbstractAnnotation(Priority priority, String message, int start, int end, String category, String type) {
        this(message, start, end, category, type);
        this.priority = priority;
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    public String getMessage() {
        return this.message;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public final long getKey() {
        return this.key;
    }

    public final String getFileName() {
        return this.fileName;
    }

    public String getTempName(AbstractBuild<?, ?> owner) {
        if (this.fileName != null) {
            return owner.getRootDir().getAbsolutePath() + "/" + WORKSPACE_FILES + "/" + Integer.toHexString(this.fileName.hashCode()) + ".tmp";
        }
        return "";
    }

    public String getCategory() {
        return this.category;
    }

    public String getType() {
        return this.type;
    }

    public final void setFileName(String fileName) {
        this.fileName = StringUtils.strip((String)fileName).replace('\\', '/');
    }

    public final String getModuleName() {
        return StringUtils.defaultIfEmpty((String)this.moduleName, (String)"Default Module");
    }

    public final void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public final String getPackageName() {
        return StringUtils.defaultIfEmpty((String)this.packageName, (String)"Default Package");
    }

    public boolean hasPackageName() {
        return StringUtils.isNotBlank((String)this.packageName);
    }

    public final void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public final Collection<LineRange> getLineRanges() {
        return Collections.unmodifiableCollection(this.lineRanges);
    }

    public final int getPrimaryLineNumber() {
        return this.primaryLineNumber;
    }

    public void addLineRange(LineRange lineRange) {
        if (!this.lineRanges.contains(lineRange)) {
            this.lineRanges.add(lineRange);
        }
    }

    public long getContextHashCode() {
        return this.contextHashCode;
    }

    public void setContextHashCode(long contextHashCode) {
        this.contextHashCode = contextHashCode;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + (this.category == null ? 0 : this.category.hashCode());
        result = prime * result + (this.fileName == null ? 0 : this.fileName.hashCode());
        result = prime * result + (this.lineRanges == null ? 0 : ((Object)this.lineRanges).hashCode());
        result = prime * result + (this.message == null ? 0 : this.message.hashCode());
        result = prime * result + (this.moduleName == null ? 0 : this.moduleName.hashCode());
        result = prime * result + (this.packageName == null ? 0 : this.packageName.hashCode());
        result = prime * result + this.primaryLineNumber;
        result = prime * result + (this.priority == null ? 0 : this.priority.hashCode());
        result = prime * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractAnnotation other = (AbstractAnnotation)obj;
        if (this.category == null ? other.category != null : !this.category.equals(other.category)) {
            return false;
        }
        if (this.fileName == null ? other.fileName != null : !this.fileName.equals(other.fileName)) {
            return false;
        }
        if (this.lineRanges == null ? other.lineRanges != null : !((Object)this.lineRanges).equals(other.lineRanges)) {
            return false;
        }
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        if (this.moduleName == null ? other.moduleName != null : !this.moduleName.equals(other.moduleName)) {
            return false;
        }
        if (this.packageName == null ? other.packageName != null : !this.packageName.equals(other.packageName)) {
            return false;
        }
        if (this.primaryLineNumber != other.primaryLineNumber) {
            return false;
        }
        if (this.priority == null ? other.priority != null : !this.priority.equals((Object)other.priority)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public String getShortFileName() {
        if (this.getFileName().contains("/")) {
            return StringUtils.substringAfterLast((String)this.getFileName(), (String)"/");
        }
        return this.getFileName();
    }

    public final boolean canDisplayFile(AbstractBuild<?, ?> owner) {
        return new File(this.getFileName()).exists() || new File(this.getTempName(owner)).exists();
    }

    public int compareTo(FileAnnotation other) {
        return this.getFileName().compareTo(other.getFileName());
    }
}

