/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs.util;

import hudson.model.Result;
import hudson.plugins.findbugs.util.ParserResult;
import hudson.plugins.findbugs.util.PluginLogger;
import hudson.plugins.findbugs.util.model.Priority;
import org.apache.commons.lang.StringUtils;

public class BuildResultEvaluator {
    public Result evaluateBuildResult(PluginLogger logger, Priority minimumPriority, ParserResult result, String threshold, String failureThreshold, ParserResult newResult, String newThreshold, String newFailureThreshold) {
        int annotationCount = 0;
        int newAnnotationCount = 0;
        for (Priority priority : Priority.collectPrioritiesFrom((Priority)minimumPriority)) {
            annotationCount += result.getNumberOfAnnotations(priority);
            newAnnotationCount += newResult.getNumberOfAnnotations(priority);
        }
        logger.log(String.format("Found %d annotations (%d new, %d high, %d normal, %d low)", result.getNumberOfAnnotations(), newAnnotationCount, result.getNumberOfAnnotations(Priority.HIGH), result.getNumberOfAnnotations(Priority.NORMAL), result.getNumberOfAnnotations(Priority.LOW)));
        if (minimumPriority != Priority.LOW) {
            logger.log(String.format("Considering %d annotations for build status evaluation", annotationCount));
            logger.log(String.format("Considering %d new annotations for build status evaluation", newAnnotationCount));
        }
        if (this.isAnnotationCountExceeded(annotationCount, failureThreshold)) {
            logger.log("Setting build status to FAILURE since total number of annotations exceeds the threshold " + failureThreshold);
            return Result.FAILURE;
        }
        if (this.isAnnotationCountExceeded(newAnnotationCount, newFailureThreshold)) {
            logger.log("Setting build status to FAILURE since total number of new annotations exceeds the threshold " + newFailureThreshold);
            return Result.FAILURE;
        }
        if (this.isAnnotationCountExceeded(annotationCount, threshold)) {
            logger.log("Setting build status to UNSTABLE since total number of annotations exceeds the threshold " + threshold);
            return Result.UNSTABLE;
        }
        if (this.isAnnotationCountExceeded(newAnnotationCount, newThreshold)) {
            logger.log("Setting build status to UNSTABLE since total number of new annotations exceeds the threshold " + newThreshold);
            return Result.UNSTABLE;
        }
        logger.log("Don't changing build status, no threshold has been exceeded");
        return Result.SUCCESS;
    }

    public boolean isAnnotationCountExceeded(int annotationCount, String annotationThreshold) {
        if (annotationCount > 0 && this.isValidThreshold(annotationThreshold)) {
            return annotationCount > this.convertThreshold(annotationThreshold);
        }
        return false;
    }

    private boolean isValidThreshold(String annotationThreshold) {
        if (StringUtils.isNotBlank((String)annotationThreshold)) {
            try {
                return Integer.valueOf(annotationThreshold) >= 0;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    private int convertThreshold(String annotationThreshold) {
        if (StringUtils.isNotBlank((String)annotationThreshold)) {
            try {
                return Integer.valueOf(annotationThreshold);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("Not a parsable integer value: " + annotationThreshold);
    }
}

