/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs.util;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.FilePath;
import hudson.maven.MavenBuild;
import hudson.maven.MavenModule;
import hudson.model.AbstractBuild;
import hudson.model.HealthReport;
import hudson.model.HealthReportingAction;
import hudson.model.Result;
import hudson.plugins.findbugs.util.AbstractHealthDescriptor;
import hudson.plugins.findbugs.util.BuildResult;
import hudson.plugins.findbugs.util.BuildResultEvaluator;
import hudson.plugins.findbugs.util.HealthDescriptor;
import hudson.plugins.findbugs.util.HealthReportBuilder;
import hudson.plugins.findbugs.util.NullHealthDescriptor;
import hudson.plugins.findbugs.util.ParserResult;
import hudson.plugins.findbugs.util.PluginDescriptor;
import hudson.plugins.findbugs.util.PluginLogger;
import hudson.plugins.findbugs.util.ResultAction;
import hudson.plugins.findbugs.util.ToolTipProvider;
import hudson.plugins.findbugs.util.model.AnnotationProvider;
import hudson.plugins.findbugs.util.model.Priority;
import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.data.category.CategoryDataset;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResultAction<T extends BuildResult>
implements StaplerProxy,
HealthReportingAction,
ToolTipProvider,
ResultAction<T> {
    private static final long serialVersionUID = -7201451538713818948L;
    private static final int WIDTH = 500;
    @SuppressWarnings(value={"Se"})
    private final AbstractBuild<?, ?> owner;
    private final AbstractHealthDescriptor healthDescriptor;
    private T result;
    @Deprecated
    @SuppressWarnings(value={"UuF"})
    private transient HealthReportBuilder healthReportBuilder;

    public AbstractResultAction(AbstractBuild<?, ?> owner, AbstractHealthDescriptor healthDescriptor, T result) {
        this.owner = owner;
        this.result = result;
        this.healthDescriptor = healthDescriptor;
    }

    public AbstractResultAction(AbstractBuild<?, ?> owner, AbstractHealthDescriptor healthDescriptor) {
        this.owner = owner;
        this.healthDescriptor = healthDescriptor;
    }

    public AbstractHealthDescriptor getHealthDescriptor() {
        if (this.healthDescriptor != null) {
            return this.healthDescriptor;
        }
        return NullHealthDescriptor.NULL_HEALTH_DESCRIPTOR;
    }

    protected abstract PluginDescriptor getDescriptor();

    public String getUrlName() {
        return this.getDescriptor().getPluginResultUrlName();
    }

    public final HealthReportBuilder getHealthReportBuilder() {
        return new HealthReportBuilder(this.getHealthDescriptor());
    }

    public final HealthReport getBuildHealth() {
        return this.getHealthReportBuilder().computeHealth((AnnotationProvider)this.getResult());
    }

    public final AbstractBuild<?, ?> getOwner() {
        return this.owner;
    }

    public final Object getTarget() {
        return this.getResult();
    }

    public final T getResult() {
        return (T)this.result;
    }

    public final void setResult(T result) {
        this.result = result;
    }

    public String getIconFileName() {
        if (this.getResult().getNumberOfAnnotations() > 0) {
            return this.getDescriptor().getIconUrl();
        }
        return null;
    }

    public final void doGraph(StaplerRequest request, StaplerResponse response, int height) throws IOException {
        if (ChartUtil.awtProblemCause != null) {
            response.sendRedirect2(request.getContextPath() + "/images/headless.png");
            return;
        }
        ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)this.createChart(request), (int)500, (int)height);
    }

    public final void doGraphMap(StaplerRequest request, StaplerResponse response, int height) throws IOException {
        ChartUtil.generateClickableMap((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)this.createChart(request), (int)500, (int)height);
    }

    private JFreeChart createChart(StaplerRequest request) {
        String parameter = request.getParameter("useHealthBuilder");
        boolean useHealthBuilder = Boolean.valueOf(StringUtils.defaultIfEmpty((String)parameter, (String)"true"));
        return this.getHealthReportBuilder().createGraph(useHealthBuilder, this.getDescriptor().getPluginResultUrlName(), this.buildDataSet(useHealthBuilder), (ToolTipProvider)this);
    }

    protected CategoryDataset buildDataSet(boolean useHealthBuilder) {
        DataSetBuilder builder = new DataSetBuilder();
        for (AbstractResultAction action = this; action != null; action = action.getPreviousBuild()) {
            List<Integer> series;
            BuildResult current = action.getResult();
            if (current == null) continue;
            if (useHealthBuilder && this.getHealthReportBuilder().isEnabled()) {
                series = this.getHealthReportBuilder().createSeries(current.getNumberOfAnnotations());
            } else {
                series = new ArrayList<Integer>();
                series.add(current.getNumberOfAnnotations(Priority.LOW));
                series.add(current.getNumberOfAnnotations(Priority.NORMAL));
                series.add(current.getNumberOfAnnotations(Priority.HIGH));
            }
            int level = 0;
            for (Integer integer : series) {
                builder.add((Number)integer, (Comparable)Integer.valueOf(level), (Comparable)new ChartUtil.NumberOnlyBuildLabel(action.getOwner()));
                ++level;
            }
        }
        return builder.build();
    }

    protected AbstractResultAction<T> getPreviousBuild() {
        AbstractResultAction action;
        AbstractBuild build = this.getOwner();
        do {
            if ((build = (AbstractBuild)build.getPreviousBuild()) != null) continue;
            return null;
        } while ((action = (AbstractResultAction)build.getAction(this.getClass())) == null);
        return action;
    }

    public boolean hasPreviousResultAction() {
        return this.getPreviousBuild() != null;
    }

    protected ParserResult createAggregatedResult(Map<MavenModule, List<MavenBuild>> moduleBuilds) {
        ParserResult project = this.createResult();
        for (List<MavenBuild> builds : moduleBuilds.values()) {
            if (builds.isEmpty()) continue;
            this.addModule(project, builds);
        }
        return project;
    }

    protected ParserResult createResult() {
        return new ParserResult();
    }

    protected void addModule(ParserResult aggregatedResult, List<MavenBuild> builds) {
        MavenBuild mavenBuild = builds.get(0);
        AbstractResultAction action = (AbstractResultAction)mavenBuild.getAction(this.getClass());
        if (action != null) {
            aggregatedResult.addAnnotations(action.getResult().getAnnotations());
            aggregatedResult.addModules(action.getResult().getModules());
            aggregatedResult.addErrors(action.getResult().getErrors());
            FilePath filePath = new FilePath(new File(mavenBuild.getRootDir(), "workspace-files"));
            try {
                filePath.copyRecursiveTo("*.tmp", new FilePath(new File(this.getOwner().getRootDir(), "workspace-files")));
            }
            catch (IOException exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Can't copy workspace files: ", exception);
            }
            catch (InterruptedException exception) {
                // empty catch block
            }
        }
    }

    protected void updateBuildHealth(MavenBuild build, BuildResult buildResult) {
        Result hudsonResult = new BuildResultEvaluator().evaluateBuildResult(new PluginLogger(System.out, "[" + this.getDisplayName() + "] "), (HealthDescriptor)this.getHealthDescriptor(), buildResult.getAnnotations(), buildResult.getNewWarnings());
        if (hudsonResult != Result.SUCCESS) {
            build.setResult(hudsonResult);
        }
    }
}

