/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs.util;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Project;
import hudson.model.Result;
import hudson.plugins.findbugs.util.AbortException;
import hudson.plugins.findbugs.util.BuildResult;
import hudson.plugins.findbugs.util.BuildResultEvaluator;
import hudson.plugins.findbugs.util.HealthDescriptor;
import hudson.plugins.findbugs.util.PluginLogger;
import hudson.plugins.findbugs.util.TrendReportHeightValidator;
import hudson.plugins.findbugs.util.model.DefaultAnnotationContainer;
import hudson.plugins.findbugs.util.model.FileAnnotation;
import hudson.plugins.findbugs.util.model.Priority;
import hudson.plugins.findbugs.util.model.WorkspaceFile;
import hudson.remoting.VirtualChannel;
import hudson.tasks.Ant;
import hudson.tasks.Builder;
import hudson.tasks.Maven;
import hudson.tasks.Publisher;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HealthAwarePublisher
extends Publisher
implements HealthDescriptor {
    private static final long serialVersionUID = -7945220365563528457L;
    private static final String DEFAULT_PRIORITY_THRESHOLD_LIMIT = "low";
    private final String threshold;
    private final String newThreshold;
    private final String failureThreshold;
    private final String newFailureThreshold;
    private final String healthy;
    private final String unHealthy;
    private final String height;
    private final String pluginName;
    private String thresholdLimit;
    private final String defaultEncoding;
    @Deprecated
    private transient boolean thresholdEnabled;
    @Deprecated
    private transient int minimumAnnotations;
    @Deprecated
    private transient int healthyAnnotations;
    @Deprecated
    private transient int unHealthyAnnotations;
    @Deprecated
    private transient boolean healthyReportEnabled;

    public HealthAwarePublisher(String threshold, String newThreshold, String failureThreshold, String newFailureThreshold, String healthy, String unHealthy, String height, String thresholdLimit, String defaultEncoding, String pluginName) {
        this.threshold = threshold;
        this.newThreshold = newThreshold;
        this.failureThreshold = failureThreshold;
        this.newFailureThreshold = newFailureThreshold;
        this.healthy = healthy;
        this.unHealthy = unHealthy;
        this.height = height;
        this.thresholdLimit = thresholdLimit;
        this.defaultEncoding = defaultEncoding;
        this.pluginName = "[" + pluginName + "] ";
    }

    protected Object readResolve() {
        if (this.thresholdLimit == null) {
            this.thresholdLimit = DEFAULT_PRIORITY_THRESHOLD_LIMIT;
        }
        return this;
    }

    public final boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (this.canContinue(build.getResult())) {
            PluginLogger logger = new PluginLogger(listener.getLogger(), this.pluginName);
            try {
                BuildResult annotationsResult = this.perform(build, logger);
                Result buildResult = new BuildResultEvaluator().evaluateBuildResult(logger, this, annotationsResult.getAnnotations(), annotationsResult.getNewWarnings());
                if (buildResult != Result.SUCCESS) {
                    build.setResult(buildResult);
                }
                if (build.getProject().getWorkspace().isRemote()) {
                    this.copyFilesFromSlaveToMaster(build.getRootDir(), launcher.getChannel(), annotationsResult.getAnnotations());
                }
            }
            catch (AbortException exception) {
                logger.log(exception);
                build.setResult(Result.FAILURE);
                return false;
            }
        }
        return true;
    }

    private void copyFilesFromSlaveToMaster(File rootDir, VirtualChannel channel, Collection<FileAnnotation> annotations) throws IOException, FileNotFoundException, InterruptedException {
        File directory = new File(rootDir, "workspace-files");
        if (!directory.exists() && !directory.mkdir()) {
            throw new IOException("Can't create directory for workspace files that contain annotations: " + directory.getAbsolutePath());
        }
        DefaultAnnotationContainer container = new DefaultAnnotationContainer(annotations);
        for (WorkspaceFile file : container.getFiles()) {
            File masterFile = new File(directory, file.getTempName());
            if (masterFile.exists()) continue;
            try {
                FileOutputStream outputStream = new FileOutputStream(masterFile);
                new FilePath(channel, file.getName()).copyTo((OutputStream)outputStream);
            }
            catch (IOException exception) {
                this.logExceptionToFile(exception, masterFile, file.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void logExceptionToFile(IOException exception, File masterFile, String slaveFileName) {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(masterFile);
            String message = "Can't copy file from slave to master: slave=" + slaveFileName + ", master=" + masterFile.getAbsolutePath();
            exception.printStackTrace(new PrintStream(outputStream));
            IOUtils.write((String)message, (OutputStream)outputStream);
        }
        catch (IOException error) {
            IOUtils.closeQuietly((OutputStream)outputStream);
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
    }

    protected boolean canContinue(Result result) {
        return result != Result.ABORTED && result != Result.FAILURE;
    }

    protected abstract BuildResult perform(AbstractBuild<?, ?> var1, PluginLogger var2) throws InterruptedException, IOException;

    @Override
    public String getThreshold() {
        return this.threshold;
    }

    @Override
    public String getNewThreshold() {
        return this.newThreshold;
    }

    @Override
    public String getFailureThreshold() {
        return this.failureThreshold;
    }

    @Override
    public String getNewFailureThreshold() {
        return this.newFailureThreshold;
    }

    @Override
    public String getHealthy() {
        return this.healthy;
    }

    @Override
    public String getUnHealthy() {
        return this.unHealthy;
    }

    public String getHeight() {
        return this.height;
    }

    public int getTrendHeight() {
        return TrendReportHeightValidator.defaultHeight(this.height);
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    protected boolean isMavenBuild(AbstractBuild<?, ?> build) {
        if (build.getProject() instanceof Project) {
            Project project = (Project)build.getProject();
            for (Builder builder : project.getBuilders()) {
                if (!(builder instanceof Maven)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isAntBuild(AbstractBuild<?, ?> build) {
        if (build.getProject() instanceof Project) {
            Project project = (Project)build.getProject();
            for (Builder builder : project.getBuilders()) {
                if (!(builder instanceof Ant)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Priority getMinimumPriority() {
        return Priority.valueOf(StringUtils.upperCase((String)this.getThresholdLimit()));
    }

    public String getThresholdLimit() {
        return this.thresholdLimit;
    }
}

