/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs.util;

import hudson.plugins.findbugs.util.AbstractHealthDescriptor;
import hudson.plugins.findbugs.util.BuildResult;
import hudson.plugins.findbugs.util.GraphType;
import hudson.plugins.findbugs.util.ResultAction;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jfree.chart.JFreeChart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class GraphConfiguration {
    private static final int DEFAULT_COUNT = 0;
    private static final GraphType DEFAULT_GRAPH = GraphType.PRIORITY;
    protected static final int DEFAULT_WIDTH = 500;
    protected static final int DEFAULT_HEIGHT = 200;
    private static final String SEPARATOR = "!";
    private int height;
    private int width;
    private GraphType graphType;
    private int buildCount;
    private int dayCount;

    public GraphConfiguration(String value) {
        if (!this.initializeFrom(value)) {
            this.reset();
        }
    }

    public GraphConfiguration(String value, File defaultsFile) {
        if (!this.initializeFrom(value)) {
            if (defaultsFile.exists()) {
                String defaultValue = this.readFromDefaultsFile(defaultsFile);
                if (!this.initializeFrom(defaultValue)) {
                    this.reset();
                }
            } else {
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String readFromDefaultsFile(File defaultsFile) {
        String defaultValue = "";
        FileInputStream input = null;
        try {
            input = new FileInputStream(defaultsFile);
            defaultValue = IOUtils.toString((InputStream)input);
        }
        catch (IOException exception) {
            IOUtils.closeQuietly((InputStream)input);
            catch (Throwable throwable) {
                IOUtils.closeQuietly(input);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)input);
        return defaultValue;
    }

    private void reset() {
        this.height = 200;
        this.width = 500;
        this.buildCount = 0;
        this.dayCount = 0;
        this.graphType = DEFAULT_GRAPH;
    }

    private boolean initializeFrom(String value) {
        if (StringUtils.isBlank((String)value)) {
            return false;
        }
        String[] values = StringUtils.split((String)value, (String)"!");
        if (values.length != 5) {
            return false;
        }
        try {
            this.width = Integer.parseInt(values[0]);
            this.height = Integer.parseInt(values[1]);
            this.buildCount = Integer.parseInt(values[2]);
            this.dayCount = Integer.parseInt(values[3]);
            this.graphType = GraphType.valueOf((String)values[4]);
        }
        catch (NumberFormatException exception) {
            return false;
        }
        catch (IllegalArgumentException exception) {
            return false;
        }
        return GraphConfiguration.isValid((int)this.width, (int)this.height, (int)this.buildCount, (int)this.dayCount, (GraphType)this.graphType);
    }

    protected String serializeToString(int width, int height, int buildCount, int dayCount, GraphType graphType) {
        return width + "!" + height + "!" + buildCount + "!" + dayCount + "!" + graphType;
    }

    protected static boolean isValid(int newWidth, int newHeight, int newBuildCount, int newDayCount, GraphType newGraphType) {
        return GraphConfiguration.isValidWidth((int)newWidth) && GraphConfiguration.isValidHeight((int)newHeight) && newGraphType != null && newDayCount >= 0 && GraphConfiguration.isValidBuildCount((int)newBuildCount);
    }

    protected static boolean isValidBuildCount(int newBuildCount) {
        return newBuildCount == 0 || newBuildCount > 1;
    }

    protected static boolean isValidWidth(int newWidth) {
        return newWidth > 25 && newWidth < 2000;
    }

    protected static boolean isValidHeight(int newHeight) {
        return newHeight > 25 && newHeight < 2000;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getBuildCount() {
        return this.buildCount;
    }

    public boolean isBuildCountDefined() {
        return this.buildCount > 1;
    }

    public int getDayCount() {
        return this.dayCount;
    }

    public boolean isDayCountDefined() {
        return this.dayCount > 0;
    }

    public GraphType getGraphType() {
        return this.graphType;
    }

    public JFreeChart createGraph(AbstractHealthDescriptor healthDescriptor, ResultAction<? extends BuildResult> resultAction, String url) {
        return this.getGraphType().createGraph(this, healthDescriptor, resultAction, url);
    }

    public boolean isDefault() {
        return this.width == 500 && this.height == 200 && this.graphType == DEFAULT_GRAPH && this.buildCount == 0 && this.dayCount == 0;
    }

    public boolean isVisible() {
        return this.graphType != GraphType.NONE;
    }

    public String toString() {
        return "type: " + this.graphType + ", size: " + this.width + "x" + this.height + ", # builds " + this.buildCount + ", # days " + this.dayCount;
    }
}

