/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs.parser.maven;

import org.apache.commons.lang.StringUtils;

public class BugInstance {
    private static final String RANGE_SEPARATOR = "-";
    private String type;
    private String category;
    private String priority;
    private String message;
    private int start;
    private int end;
    private String lineNumberExpression;

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public int getLineNumber() {
        return this.start;
    }

    public void setLineNumberExpression(String lineNumberString) {
        this.lineNumberExpression = lineNumberString;
        try {
            if (lineNumberString.contains(RANGE_SEPARATOR)) {
                this.start = Integer.valueOf(StringUtils.substringBefore((String)lineNumberString, (String)RANGE_SEPARATOR));
                this.end = Integer.valueOf(StringUtils.substringAfter((String)lineNumberString, (String)RANGE_SEPARATOR));
            } else {
                this.start = Integer.valueOf(lineNumberString);
                this.end = Integer.valueOf(lineNumberString);
            }
        }
        catch (NumberFormatException exception) {
            this.start = 0;
            this.end = 0;
        }
    }

    public String getLineNumberExpression() {
        return this.lineNumberExpression;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + (this.category == null ? 0 : this.category.hashCode());
        result = prime * result + this.end;
        result = prime * result + (this.lineNumberExpression == null ? 0 : this.lineNumberExpression.hashCode());
        result = prime * result + (this.message == null ? 0 : this.message.hashCode());
        result = prime * result + (this.priority == null ? 0 : this.priority.hashCode());
        result = prime * result + this.start;
        result = prime * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BugInstance other = (BugInstance)obj;
        if (this.category == null ? other.category != null : !this.category.equals(other.category)) {
            return false;
        }
        if (this.end != other.end) {
            return false;
        }
        if (this.lineNumberExpression == null ? other.lineNumberExpression != null : !this.lineNumberExpression.equals(other.lineNumberExpression)) {
            return false;
        }
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        if (this.priority == null ? other.priority != null : !this.priority.equals(other.priority)) {
            return false;
        }
        if (this.start != other.start) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

