/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs.parser;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import edu.umd.cs.findbugs.ba.SourceFile;
import edu.umd.cs.findbugs.ba.SourceFinder;
import hudson.plugins.analysis.core.AnnotationParser;
import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.plugins.analysis.util.model.LineRange;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.findbugs.FindBugsMessages;
import hudson.plugins.findbugs.parser.Bug;
import hudson.plugins.findbugs.parser.XmlBugInstance;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.digester.Digester;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.DocumentException;
import org.jvnet.localizer.LocaleProvider;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindBugsParser
implements AnnotationParser {
    private static final long serialVersionUID = 8306319007761954027L;
    private static final String DOT = ".";
    private static final String SLASH = "/";
    @SuppressWarnings(value={"SE"})
    private final List<String> mavenSources = new ArrayList<String>();

    public FindBugsParser() {
        this(new ArrayList<String>());
    }

    public FindBugsParser(Collection<String> sourceFolders) {
        this.mavenSources.addAll(sourceFolders);
    }

    public Collection<FileAnnotation> parse(File file, String moduleName) throws InvocationTargetException {
        try {
            ArrayList<String> sources = new ArrayList<String>(this.mavenSources);
            if (sources.isEmpty()) {
                String moduleRoot = StringUtils.substringBefore((String)file.getAbsolutePath().replace('\\', '/'), (String)"/target/");
                sources.add(moduleRoot + "/src/main/java");
                sources.add(moduleRoot + "/src/test/java");
                sources.add(moduleRoot + "/src");
            }
            return this.parse(file, sources, moduleName);
        }
        catch (IOException exception) {
            throw new InvocationTargetException(exception);
        }
        catch (SAXException exception) {
            throw new InvocationTargetException(exception);
        }
        catch (DocumentException exception) {
            throw new InvocationTargetException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<FileAnnotation> parse(File file, Collection<String> sources, String moduleName) throws IOException, DocumentException, SAXException {
        Collection<FileAnnotation> collection;
        FileInputStream input = null;
        try {
            input = new FileInputStream(file);
            Map<String, String> hashToMessageMapping = this.createHashToMessageMapping(input);
            IOUtils.closeQuietly((InputStream)input);
            input = new FileInputStream(file);
            collection = this.parse(input, sources, moduleName, hashToMessageMapping);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(input);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)input);
        return collection;
    }

    public Map<String, String> createHashToMessageMapping(InputStream file) throws SAXException, IOException {
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.setClassLoader(FindBugsParser.class.getClassLoader());
        String rootXPath = "BugCollection/BugInstance";
        digester.addObjectCreate(rootXPath, XmlBugInstance.class);
        digester.addSetProperties(rootXPath);
        String fileXPath = rootXPath + "/LongMessage";
        digester.addCallMethod(fileXPath, "setMessage", 0);
        digester.addSetNext(rootXPath, "add", Object.class.getName());
        ArrayList bugs = new ArrayList();
        digester.push(bugs);
        digester.parse(file);
        HashMap<String, String> mapping = new HashMap<String, String>();
        for (XmlBugInstance bug : bugs) {
            mapping.put(bug.getInstanceHash(), bug.getMessage());
        }
        return mapping;
    }

    public Collection<FileAnnotation> parse(InputStream file, Collection<String> sources, String moduleName, Map<String, String> hashToMessageMapping) throws IOException, DocumentException {
        SortedBugCollection collection = new SortedBugCollection();
        collection.readXML(file);
        Project project = collection.getProject();
        for (String sourceFolder : sources) {
            project.addSourceDir(sourceFolder);
        }
        SourceFinder sourceFinder = new SourceFinder(project);
        String actualName = this.extractModuleName(moduleName, project);
        ArrayList<FileAnnotation> annotations = new ArrayList<FileAnnotation>();
        Collection bugs = collection.getCollection();
        for (BugInstance warning : bugs) {
            String fileName;
            SourceLineAnnotation sourceLine = warning.getPrimarySourceLineAnnotation();
            String message = warning.getMessage();
            if (message.contains("TEST: Unknown")) {
                message = FindBugsMessages.getInstance().getShortMessage(warning.getType(), LocaleProvider.getLocale());
            }
            Bug bug = new Bug(this.getPriority(warning), StringUtils.defaultIfEmpty((String)hashToMessageMapping.get(warning.getInstanceHash()), (String)message), warning.getBugPattern().getCategory(), warning.getType(), sourceLine.getStartLine(), sourceLine.getEndLine());
            bug.setInstanceHash(warning.getInstanceHash());
            Iterator annotationIterator = warning.annotationIterator();
            while (annotationIterator.hasNext()) {
                BugAnnotation bugAnnotation = (BugAnnotation)annotationIterator.next();
                if (!(bugAnnotation instanceof SourceLineAnnotation)) continue;
                SourceLineAnnotation annotation = (SourceLineAnnotation)bugAnnotation;
                bug.addLineRange(new LineRange(annotation.getStartLine(), annotation.getEndLine()));
            }
            try {
                SourceFile sourceFile = sourceFinder.findSourceFile(sourceLine);
                fileName = sourceFile.getFullFileName();
            }
            catch (IOException exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Can't resolve absolute file name for file " + sourceLine.getSourceFile() + ", dir list = " + project.getSourceDirList().toString());
                fileName = sourceLine.getPackageName().replace(DOT, SLASH) + SLASH + sourceLine.getSourceFile();
            }
            bug.setFileName(fileName);
            bug.setPackageName(warning.getPrimaryClass().getPackageName());
            bug.setModuleName(actualName);
            annotations.add((FileAnnotation)bug);
        }
        return annotations;
    }

    private Priority getPriority(BugInstance warning) {
        switch (warning.getPriority()) {
            case 1: {
                return Priority.HIGH;
            }
            case 2: {
                return Priority.NORMAL;
            }
        }
        return Priority.LOW;
    }

    private String extractModuleName(String defaultName, Project project) {
        if (StringUtils.isBlank((String)project.getProjectName())) {
            return defaultName;
        }
        return project.getProjectName();
    }

    static {
        DetectorFactoryCollection.rawInstance().setPluginList(new URL[0]);
    }
}

