/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs;

import com.thoughtworks.xstream.XStream;
import hudson.model.AbstractBuild;
import hudson.plugins.analysis.core.BuildHistory;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.core.ParserResult;
import hudson.plugins.analysis.core.ResultAction;
import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.plugins.findbugs.FindBugsResultAction;
import hudson.plugins.findbugs.Messages;
import hudson.plugins.findbugs.ResultSummary;
import hudson.plugins.findbugs.parser.Bug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindBugsResult
extends BuildResult {
    private static final long serialVersionUID = 2768250056765266658L;
    private static final int LESS_ONE_WEEK = 6;
    private int newThisWeek;
    private int notInCloud;
    private int numberOfComments;

    public FindBugsResult(AbstractBuild<?, ?> build, String defaultEncoding, ParserResult result) {
        super(build, defaultEncoding, result);
        this.init();
    }

    public FindBugsResult(AbstractBuild<?, ?> build, String defaultEncoding, ParserResult result, BuildHistory history) {
        super(build, defaultEncoding, result, history);
        this.init();
    }

    private void init() {
        for (FileAnnotation annotation : this.getAnnotations()) {
            if (!(annotation instanceof Bug)) continue;
            Bug bug = (Bug)annotation;
            if (bug.isInCloud()) {
                if (bug.getAgeInDays() <= 6) {
                    ++this.newThisWeek;
                }
                this.numberOfComments += bug.getReviewCount();
                continue;
            }
            ++this.notInCloud;
        }
    }

    public int getNumberOfComments() {
        return this.numberOfComments;
    }

    protected void configure(XStream xstream) {
        xstream.alias("bug", Bug.class);
    }

    public String getSummary() {
        return ResultSummary.createSummary((FindBugsResult)this);
    }

    public int getNewThisWeek() {
        return this.newThisWeek;
    }

    public int getNotInCloud() {
        return this.notInCloud;
    }

    protected String createDeltaMessage() {
        return ResultSummary.createDeltaMessage((FindBugsResult)this);
    }

    protected String getSerializationFileName() {
        return "findbugs-warnings.xml";
    }

    public String getDisplayName() {
        return Messages.FindBugs_ProjectAction_Name();
    }

    protected Class<? extends ResultAction<? extends BuildResult>> getResultActionType() {
        return FindBugsResultAction.class;
    }
}

