/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs.parser;

import hudson.plugins.analysis.util.model.AbstractAnnotation;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.findbugs.FindBugsMessages;
import hudson.plugins.findbugs.Messages;
import java.text.DateFormat;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.jvnet.localizer.LocaleProvider;

public class Bug
extends AbstractAnnotation {
    private static final long serialVersionUID = 5171661552905752370L;
    private static final String ORIGIN = "findbugs";
    private String tooltip = "";
    private String instanceHash;
    private int ageInDays;
    private long firstSeen;
    private int reviewCount;
    private boolean notAProblem;
    private boolean inCloud;

    public Bug(Priority priority, String message, String category, String type, int start, int end) {
        super(priority, message, start, end, category, type);
        this.setOrigin(ORIGIN);
    }

    public Bug(Priority priority, String message, String category, String type, int lineNumber) {
        this(priority, message, category, type, lineNumber, lineNumber);
    }

    public Bug(Priority priority, String message, String category, String type) {
        this(priority, message, category, type, 0, 0);
    }

    public Bug(Priority priority, String message, String category, String type, int start, int end, String tooltip) {
        this(priority, message, category, type, start, end);
        this.tooltip = tooltip;
    }

    public long getFirstSeen() {
        return this.firstSeen;
    }

    void setFirstSeen(long firstSeen) {
        this.firstSeen = firstSeen;
    }

    public void setInCloud(boolean inCloud) {
        this.inCloud = inCloud;
    }

    public boolean isInCloud() {
        return this.inCloud;
    }

    public int getAgeInDays() {
        return this.ageInDays;
    }

    void setAgeInDays(int ageInDays) {
        this.ageInDays = ageInDays;
    }

    public int getReviewCount() {
        return this.reviewCount;
    }

    void setReviewCount(int reviewCount) {
        this.reviewCount = reviewCount;
    }

    public boolean isNotAProblem() {
        return this.notAProblem;
    }

    void setNotAProblem(boolean notAProblem) {
        this.notAProblem = notAProblem;
    }

    private Object readResolve() {
        if (this.instanceHash == null) {
            this.instanceHash = String.valueOf(super.hashCode());
        }
        return this;
    }

    public String getToolTip() {
        return StringUtils.defaultIfEmpty((String)this.tooltip, (String)FindBugsMessages.getInstance().getMessage(this.getType(), LocaleProvider.getLocale()));
    }

    public String getMessage() {
        return super.getMessage() + this.getCloudInformation();
    }

    private String getCloudInformation() {
        StringBuilder cloudMessage = new StringBuilder();
        if (this.ageInDays == 1) {
            cloudMessage.append(Messages.FindBugs_Bug_cloudInfo_seenAt_singular());
        } else if (this.ageInDays > 1) {
            cloudMessage.append(Messages.FindBugs_Bug_cloudInfo_seenAt_plural(this.ageInDays));
            if (this.firstSeen > 0L) {
                DateFormat format = DateFormat.getDateTimeInstance(3, 3);
                cloudMessage.append(" ");
                cloudMessage.append(Messages.FindBugs_Bug_cloudInfo_firstSeen(format.format(new Date(this.firstSeen))));
            }
        }
        if (this.reviewCount > 0) {
            if (cloudMessage.length() > 0) {
                cloudMessage.append(" - ");
            }
            if (this.reviewCount == 1) {
                cloudMessage.append(Messages.FindBugs_Bug_cloudInfo_reviewer_singular());
            } else {
                cloudMessage.append(Messages.FindBugs_Bug_cloudInfo_reviewer_plural(this.reviewCount));
            }
        }
        if (cloudMessage.length() == 0) {
            return "";
        }
        return "<br/><br/><img src='/plugin/findbugs/icons/fb-cloud-icon-small.png' title=\"" + Messages.FindBugs_Bug_cloudInfo_title() + "\"/> " + cloudMessage.toString();
    }

    public void setInstanceHash(String instanceHash) {
        this.instanceHash = instanceHash;
    }

    public int hashCode() {
        return 31 + (this.instanceHash == null ? 0 : this.instanceHash.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Bug other = (Bug)((Object)obj);
        return !(this.instanceHash == null ? other.instanceHash != null : !this.instanceHash.equals(other.instanceHash));
    }
}

