/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.plugins.findbugs.Messages;
import hudson.plugins.findbugs.Pattern;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.digester.Digester;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FindBugsMessages {
    private final Map<String, String> messages = new HashMap();
    private final Map<String, String> jaMessages = new HashMap();
    private final Map<String, String> frMessages = new HashMap();
    private final Map<String, String> shortMessages = new HashMap();
    private final Map<String, String> jaShortMessages = new HashMap();
    private final Map<String, String> frShortMessages = new HashMap();
    private static final FindBugsMessages INSTANCE = new FindBugsMessages();

    public static FindBugsMessages getInstance() {
        return INSTANCE;
    }

    @SuppressWarnings(value={"DE", "REC"})
    public synchronized void initialize() throws IOException, SAXException {
        this.loadMessages("messages.xml", this.messages, this.shortMessages);
        try {
            this.loadMessages("messages_fr.xml", this.frMessages, this.frShortMessages);
            this.loadMessages("messages_ja.xml", this.jaMessages, this.jaShortMessages);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.loadMessages("fb-contrib-messages.xml", this.messages, this.shortMessages);
    }

    private void loadMessages(String fileName, Map<String, String> messagesCache, Map<String, String> shortMessagesCache) throws IOException, SAXException {
        InputStream file = FindBugsMessages.class.getResourceAsStream(fileName);
        List patterns = this.parse(file);
        for (Pattern pattern : patterns) {
            messagesCache.put(pattern.getType(), pattern.getDescription());
            shortMessagesCache.put(pattern.getType(), pattern.getShortDescription());
        }
    }

    public List<Pattern> parse(InputStream file) throws IOException, SAXException {
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.setClassLoader(FindBugsMessages.class.getClassLoader());
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        digester.push(patterns);
        digester.addObjectCreate("*/BugPattern", Pattern.class);
        digester.addSetProperties("*/BugPattern");
        digester.addCallMethod("*/BugPattern/Details", "setDescription", 0);
        digester.addCallMethod("*/BugPattern/ShortDescription", "setShortDescription", 0);
        digester.addSetNext("*/BugPattern", "add");
        digester.parse(file);
        return patterns;
    }

    public String getMessage(String name, Locale locale) {
        String localizedMessage = this.getLocalizedMessage(name, locale, this.messages, this.jaMessages, this.frMessages);
        return StringUtils.defaultIfEmpty((String)localizedMessage, (String)Messages.FindBugs_Publisher_NoMessageFoundText());
    }

    public String getShortMessage(String name, Locale locale) {
        String localizedMessage = this.getLocalizedMessage(name, locale, this.shortMessages, this.jaShortMessages, this.frShortMessages);
        return StringUtils.defaultIfEmpty((String)localizedMessage, (String)Messages.FindBugs_Publisher_NoMessageFoundText());
    }

    private String getLocalizedMessage(String name, Locale locale, Map<String, String> en, Map<String, String> ja, Map<String, String> fr) {
        String country = locale.getLanguage();
        String localizedMessage = "ja".equalsIgnoreCase(country) ? ja.get(name) : ("fr".equalsIgnoreCase(country) ? fr.get(name) : en.get(name));
        return localizedMessage;
    }

    private FindBugsMessages() {
    }
}

