/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs;

import hudson.FilePath;
import hudson.maven.MavenBuild;
import hudson.maven.MavenBuildProxy;
import hudson.maven.MavenModule;
import hudson.maven.MavenReporter;
import hudson.maven.MojoInfo;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.plugins.analysis.core.AnnotationParser;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.core.FilesParser;
import hudson.plugins.analysis.core.HealthAwareMavenReporter;
import hudson.plugins.analysis.core.HealthDescriptor;
import hudson.plugins.analysis.core.ParserResult;
import hudson.plugins.analysis.util.PluginLogger;
import hudson.plugins.findbugs.FindBugsProjectAction;
import hudson.plugins.findbugs.FindBugsResult;
import hudson.plugins.findbugs.FindBugsResultBuilder;
import hudson.plugins.findbugs.MavenFindBugsResultAction;
import hudson.plugins.findbugs.parser.FindBugsParser;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindBugsReporter
extends HealthAwareMavenReporter {
    private static final long serialVersionUID = -288391908253344862L;
    private static final String FINDBUGS_XML_FILE = "findbugsXml.xml";
    private static final String MAVEN_FINDBUGS_XML_FILE = "findbugs.xml";
    private transient String pattern;

    @DataBoundConstructor
    public FindBugsReporter(String threshold, String newThreshold, String failureThreshold, String newFailureThreshold, String healthy, String unHealthy, String thresholdLimit) {
        super(threshold, newThreshold, failureThreshold, newFailureThreshold, healthy, unHealthy, thresholdLimit, "FINDBUGS");
    }

    public boolean preExecute(MavenBuildProxy build, MavenProject pom, MojoInfo mojo, BuildListener listener) throws InterruptedException, IOException {
        if ("findbugs".equals(mojo.getGoal())) {
            this.activateProperty(mojo, "xmlOutput");
            this.activateProperty(mojo, "findbugsXmlOutput");
        }
        return true;
    }

    private void activateProperty(MojoInfo mojo, String property) {
        XmlPlexusConfiguration configuration = (XmlPlexusConfiguration)mojo.configuration.getChild(property);
        if (configuration != null) {
            configuration.setValue("true");
        }
    }

    protected boolean acceptGoal(String goal) {
        return "findbugs".equals(goal) || "site".equals(goal);
    }

    public ParserResult perform(MavenBuildProxy build, MavenProject pom, MojoInfo mojo, PluginLogger logger) throws InterruptedException, IOException {
        ArrayList<String> sources = new ArrayList<String>(pom.getCompileSourceRoots());
        sources.addAll(pom.getTestCompileSourceRoots());
        FilesParser findBugsCollector = new FilesParser(logger, this.determineFileName(mojo), (AnnotationParser)new FindBugsParser(build.getModuleSetRootDir(), sources), true, false);
        return (ParserResult)this.getTargetPath(pom).act((FilePath.FileCallable)findBugsCollector);
    }

    protected BuildResult persistResult(ParserResult project, MavenBuild build) {
        FindBugsResult result = new FindBugsResultBuilder().build((AbstractBuild<?, ?>)build, project, this.getDefaultEncoding());
        build.getActions().add(new MavenFindBugsResultAction((AbstractBuild<?, ?>)build, (HealthDescriptor)this, this.getDefaultEncoding(), result));
        build.registerAsProjectAction((MavenReporter)this);
        return result;
    }

    private String determineFileName(MojoInfo mojo) {
        String fileName = FINDBUGS_XML_FILE;
        try {
            Boolean isNativeFormat = (Boolean)mojo.getConfigurationValue("findbugsXmlOutput", Boolean.class);
            if (Boolean.FALSE.equals(isNativeFormat)) {
                fileName = MAVEN_FINDBUGS_XML_FILE;
            }
        }
        catch (ComponentConfigurationException componentConfigurationException) {
            // empty catch block
        }
        return fileName;
    }

    public Action getProjectAction(MavenModule module) {
        return new FindBugsProjectAction((AbstractProject<?, ?>)module);
    }

    protected Class<? extends Action> getResultActionClass() {
        return MavenFindBugsResultAction.class;
    }
}

