/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs.parser.maven;

import hudson.FilePath;
import hudson.plugins.analysis.util.FileFinder;
import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.findbugs.parser.Bug;
import hudson.plugins.findbugs.parser.maven.BugCollection;
import hudson.plugins.findbugs.parser.maven.BugInstance;
import hudson.plugins.findbugs.parser.maven.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.digester.Digester;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenFindBugsParser {
    public boolean accepts(InputStream file) {
        try {
            Digester digester = new Digester();
            digester.setValidating(false);
            digester.setClassLoader(MavenFindBugsParser.class.getClassLoader());
            digester.addObjectCreate("BugCollection/file/BugInstance", BugCollection.class);
            BugCollection module = (BugCollection)digester.parse(file);
            return module != null;
        }
        catch (IOException exception) {
            return false;
        }
        catch (SAXException exception) {
            return false;
        }
    }

    public Collection<FileAnnotation> parse(InputStream file, String moduleName, FilePath workspace) throws IOException, SAXException {
        Collection annotations = this.parse(file, moduleName);
        try {
            String[] files = (String[])workspace.act((FilePath.FileCallable)new FileFinder());
            this.mapFiles(annotations, files);
        }
        catch (InterruptedException exception) {
            // empty catch block
        }
        return annotations;
    }

    public void mapFiles(Collection<FileAnnotation> annotations, String[] files) {
        String key;
        HashMap<String, String> fileMapping = new HashMap<String, String>();
        for (int i = 0; i < files.length; ++i) {
            String name = files[i].replace('/', '.').replace('\\', '.');
            if (name.contains(".src.main.java.")) {
                key = StringUtils.substringAfterLast((String)name, (String)"src.main.java.");
                fileMapping.put(key, files[i]);
                continue;
            }
            if (name.contains(".src.test.java.")) {
                key = StringUtils.substringAfterLast((String)name, (String)"src.test.java.");
                fileMapping.put(key, files[i]);
                continue;
            }
            if (!name.contains(".src.")) continue;
            key = StringUtils.substringAfterLast((String)name, (String)"src.");
            fileMapping.put(key, files[i]);
        }
        for (FileAnnotation annotation : annotations) {
            key = StringUtils.substringBeforeLast((String)(annotation.getPackageName() + "." + annotation.getFileName()), (String)"$") + ".java";
            if (!fileMapping.containsKey(key) || !(annotation instanceof Bug)) continue;
            ((Bug)annotation).setFileName((String)fileMapping.get(key));
        }
    }

    public Collection<FileAnnotation> parse(InputStream file, String moduleName) throws IOException, SAXException {
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.setClassLoader(MavenFindBugsParser.class.getClassLoader());
        String rootXPath = "BugCollection";
        digester.addObjectCreate(rootXPath, BugCollection.class);
        digester.addSetProperties(rootXPath);
        String fileXPath = "BugCollection/file";
        digester.addObjectCreate(fileXPath, File.class);
        digester.addSetProperties(fileXPath);
        digester.addSetNext(fileXPath, "addFile", File.class.getName());
        String bugXPath = "BugCollection/file/BugInstance";
        digester.addObjectCreate(bugXPath, BugInstance.class);
        digester.addSetProperties(bugXPath, "lineNumber", "lineNumberExpression");
        digester.addSetNext(bugXPath, "addBugInstance", BugInstance.class.getName());
        BugCollection module = (BugCollection)digester.parse(file);
        if (module == null) {
            throw new SAXException("Input stream is not in maven-findbugs-plugin format.");
        }
        return this.convert(module, moduleName);
    }

    private Collection<FileAnnotation> convert(BugCollection collection, String moduleName) {
        ArrayList<FileAnnotation> annotations = new ArrayList<FileAnnotation>();
        for (File file : collection.getFiles()) {
            for (BugInstance warning : file.getBugInstances()) {
                String value = warning.getPriority();
                Priority priority = "high".equalsIgnoreCase(value) ? Priority.HIGH : ("normal".equalsIgnoreCase(value) ? Priority.NORMAL : Priority.LOW);
                Bug bug = new Bug(priority, warning.getMessage(), warning.getCategory(), warning.getType(), warning.getStart(), warning.getEnd());
                bug.setPackageName(StringUtils.substringBeforeLast((String)file.getClassname(), (String)"."));
                bug.setModuleName(moduleName);
                bug.setFileName(StringUtils.substringAfterLast((String)file.getClassname(), (String)"."));
                annotations.add((FileAnnotation)bug);
            }
        }
        return annotations;
    }
}

