/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs;

import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.plugins.analysis.core.AnnotationParser;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.core.FilesParser;
import hudson.plugins.analysis.core.HealthAwarePublisher;
import hudson.plugins.analysis.core.HealthDescriptor;
import hudson.plugins.analysis.core.ParserResult;
import hudson.plugins.analysis.util.PluginLogger;
import hudson.plugins.findbugs.FindBugsDescriptor;
import hudson.plugins.findbugs.FindBugsProjectAction;
import hudson.plugins.findbugs.FindBugsResult;
import hudson.plugins.findbugs.FindBugsResultAction;
import hudson.plugins.findbugs.parser.FindBugsParser;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindBugsPublisher
extends HealthAwarePublisher {
    private static final long serialVersionUID = -5748362182226609649L;
    private static final String ANT_DEFAULT_PATTERN = "**/findbugs.xml";
    private static final String MAVEN_DEFAULT_PATTERN = "**/findbugsXml.xml";
    private final String pattern;

    @DataBoundConstructor
    public FindBugsPublisher(String pattern, String threshold, String newThreshold, String failureThreshold, String newFailureThreshold, String healthy, String unHealthy, String thresholdLimit, String defaultEncoding, boolean useDeltaValues, boolean canRunOnFailed) {
        super(threshold, newThreshold, failureThreshold, newFailureThreshold, healthy, unHealthy, thresholdLimit, defaultEncoding, useDeltaValues, canRunOnFailed, "FINDBUGS");
        this.pattern = pattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new FindBugsProjectAction(project);
    }

    public BuildResult perform(AbstractBuild<?, ?> build, PluginLogger logger) throws InterruptedException, IOException {
        logger.log("Collecting findbugs analysis files...");
        String defaultPattern = this.isMavenBuild(build) ? MAVEN_DEFAULT_PATTERN : ANT_DEFAULT_PATTERN;
        FilesParser collector = new FilesParser(logger, StringUtils.defaultIfEmpty((String)this.getPattern(), (String)defaultPattern), (AnnotationParser)new FindBugsParser(build.getWorkspace()), this.isMavenBuild(build), this.isAntBuild(build));
        ParserResult project = (ParserResult)build.getWorkspace().act((FilePath.FileCallable)collector);
        FindBugsResult result = new FindBugsResult(build, this.getDefaultEncoding(), project);
        build.getActions().add(new FindBugsResultAction(build, (HealthDescriptor)this, result));
        return result;
    }

    public FindBugsDescriptor getDescriptor() {
        return (FindBugsDescriptor)super.getDescriptor();
    }
}

