/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.Location;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.MethodGen;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugAccumulator {
    private final BugReporter reporter;
    private final boolean performAccumulation;
    private final Map<BugInstance, Data> map = new HashMap<BugInstance, Data>();
    private final HashMap<String, BugInstance> hashes = new HashMap();

    public BugAccumulator(BugReporter reporter) {
        this.reporter = reporter;
        this.performAccumulation = AnalysisContext.currentAnalysisContext().getBoolProperty(7);
    }

    public void accumulateBug(BugInstance bug, SourceLineAnnotation sourceLine) {
        if (sourceLine == null) {
            throw new NullPointerException("Missing source line");
        }
        if (!this.performAccumulation) {
            this.reporter.reportBug(bug.addSourceLine(sourceLine));
            return;
        }
        int priority = bug.getPriority();
        bug.setPriority(2);
        String hash = bug.getInstanceHash();
        Data d = this.map.get(bug);
        if (d == null) {
            BugInstance conflictingBug = this.hashes.get(hash);
            if (conflictingBug != null) {
                if (conflictingBug.getPriority() <= priority) {
                    return;
                }
                this.map.remove(conflictingBug);
            }
            d = new Data(priority, sourceLine);
            this.map.put(bug, d);
            this.hashes.put(hash, bug);
        } else if (d.priority > priority) {
            if (d.priority >= 3) {
                d.allSource.clear();
            }
            d.priority = priority;
            d.primarySource = sourceLine;
        } else if (priority >= 3 && priority > d.priority) {
            return;
        }
        d.allSource.add(sourceLine);
    }

    public void accumulateBug(BugInstance bug, BytecodeScanningDetector visitor) {
        SourceLineAnnotation source = SourceLineAnnotation.fromVisitedInstruction(visitor);
        this.accumulateBug(bug, source);
    }

    public Iterable<? extends BugInstance> uniqueBugs() {
        return this.map.keySet();
    }

    public Iterable<? extends SourceLineAnnotation> locations(BugInstance bug) {
        return this.map.get((Object)bug).allSource;
    }

    public void reportAccumulatedBugs() {
        for (Map.Entry<BugInstance, Data> e : this.map.entrySet()) {
            BugInstance bug = e.getKey();
            Data d = e.getValue();
            bug.setPriority(d.priority);
            bug.addSourceLine(d.primarySource);
            d.allSource.remove(d.primarySource);
            for (SourceLineAnnotation source : d.allSource) {
                bug.addSourceLine(source);
                bug.describe("SOURCE_LINE_ANOTHER_INSTANCE");
            }
            this.reporter.reportBug(bug);
        }
        this.clearBugs();
    }

    public void clearBugs() {
        this.map.clear();
        this.hashes.clear();
    }

    public void accumulateBug(BugInstance bug, ClassContext classContext, Method method, Location location) {
        this.accumulateBug(bug, SourceLineAnnotation.fromVisitedInstruction(classContext, method, location));
    }

    public void accumulateBug(BugInstance bug, ClassContext classContext, MethodGen methodGen, String sourceFile, Location location) {
        this.accumulateBug(bug, SourceLineAnnotation.fromVisitedInstruction(classContext, methodGen, sourceFile, location.getHandle()));
    }

    static class Data {
        int priority;
        SourceLineAnnotation primarySource;
        List<SourceLineAnnotation> allSource = new LinkedList<SourceLineAnnotation>();

        public Data(int priority, SourceLineAnnotation primarySource) {
            this.priority = priority;
            this.primarySource = primarySource;
        }
    }
}

