/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.cloud.Cloud;
import edu.umd.cs.findbugs.util.Util;
import edu.umd.cs.findbugs.xml.XMLAttributeList;
import edu.umd.cs.findbugs.xml.XMLOutput;
import edu.umd.cs.findbugs.xml.XMLWriteable;
import java.io.IOException;
import java.io.Serializable;
import javax.annotation.Nonnull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugDesignation
implements XMLWriteable,
Serializable,
Comparable<BugDesignation> {
    public static final String UNCLASSIFIED = Cloud.UserDesignation.UNCLASSIFIED.name();
    @NonNull
    private String designation = UNCLASSIFIED;
    private boolean dirty;
    @javax.annotation.CheckForNull
    private String user;
    private long timestamp = System.currentTimeMillis();
    private String annotationText;

    public String toString() {
        String result = this.designation;
        if (this.user != null) {
            result = result + " by " + this.user;
        }
        if (this.annotationText != null && this.annotationText.length() > 0) {
            result = result + " : " + this.annotationText;
        }
        return result;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void cleanDirty() {
        this.dirty = false;
    }

    public BugDesignation() {
    }

    public BugDesignation(String designation, long timestamp, String annotationText, String user) {
        this.designation = designation;
        this.timestamp = timestamp;
        this.annotationText = annotationText;
        this.user = user;
    }

    public BugDesignation(BugDesignation that) {
        this(that.designation, that.timestamp, that.annotationText, that.user);
    }

    @NonNull
    public String getDesignationKey() {
        return this.designation;
    }

    public void setDesignationKey(String designationKey) {
        if (this.designation.equals(designationKey)) {
            return;
        }
        this.dirty = true;
        this.timestamp = System.currentTimeMillis();
        this.designation = designationKey != null ? designationKey : UNCLASSIFIED;
    }

    @CheckForNull
    public String getUser() {
        return this.user;
    }

    public void setUser(String u) {
        this.user = u;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long ts) {
        if (this.timestamp != ts) {
            this.timestamp = ts;
            this.dirty = true;
        }
    }

    @CheckForNull
    public String getAnnotationText() {
        return this.annotationText;
    }

    @Nonnull
    public String getNonnullAnnotationText() {
        if (this.annotationText == null) {
            return "";
        }
        return this.annotationText;
    }

    public void setAnnotationText(String s) {
        if (s.equals(this.annotationText)) {
            return;
        }
        this.dirty = true;
        this.annotationText = s;
        this.timestamp = System.currentTimeMillis();
    }

    @Override
    public void writeXML(XMLOutput xmlOutput) throws IOException {
        XMLAttributeList attributeList = new XMLAttributeList();
        if (this.designation != null && !UNCLASSIFIED.equals(this.designation)) {
            attributeList.addAttribute("designation", this.designation);
        }
        if (this.user != null && !"".equals(this.user)) {
            attributeList.addAttribute("user", this.user);
        }
        if (this.timestamp > 0L) {
            attributeList.addAttribute("timestamp", String.valueOf(this.timestamp));
        }
        if (this.annotationText != null && !"".equals(this.annotationText)) {
            xmlOutput.openTag("UserAnnotation", attributeList);
            xmlOutput.writeCDATA(this.annotationText);
            xmlOutput.closeTag("UserAnnotation");
        } else {
            xmlOutput.openCloseTag("UserAnnotation", attributeList);
        }
    }

    public void merge(@CheckForNull BugDesignation other) {
        if (other == null) {
            return;
        }
        boolean changed = false;
        if ((this.annotationText == null || this.annotationText.length() == 0) && other.annotationText != null && other.annotationText.length() > 0) {
            this.annotationText = other.annotationText;
            this.dirty = true;
            changed = true;
        }
        if ((this.designation == null || UNCLASSIFIED.equals(this.designation) || this.designation.length() == 0) && other.designation != null && other.designation.length() > 0) {
            this.designation = other.designation;
            this.dirty = true;
            changed = true;
        }
        if (!changed) {
            return;
        }
        if ((this.user == null || this.user.length() == 0) && other.user != null && other.user.length() > 0) {
            this.user = other.user;
        }
        if (this.timestamp == 0L && other.timestamp != 0L) {
            this.timestamp = other.timestamp;
        }
    }

    public int hashCode() {
        int hash = (int)this.timestamp;
        if (this.user != null) {
            hash += this.user.hashCode();
        }
        if (this.designation != null) {
            hash += this.designation.hashCode();
        }
        if (this.annotationText != null) {
            hash += this.annotationText.hashCode();
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BugDesignation)) {
            return false;
        }
        return this.compareTo((BugDesignation)o) == 0;
    }

    @Override
    public int compareTo(BugDesignation o) {
        if (this == o) {
            return 0;
        }
        int result = -Util.compare(this.timestamp, o.timestamp);
        if (result != 0) {
            return result;
        }
        result = Util.nullSafeCompareTo(this.user, o.user);
        if (result != 0) {
            return result;
        }
        result = Util.nullSafeCompareTo(this.designation, o.designation);
        if (result != 0) {
            return result;
        }
        result = Util.nullSafeCompareTo(this.annotationText, o.annotationText);
        if (result != 0) {
            return result;
        }
        return 0;
    }
}

