/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.Plugin;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.util.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.annotation.CheckForNull;

public class BugRanker {
    private final Scorer bugPatterns = new Scorer();
    private final Scorer bugKinds = new Scorer();
    private final Scorer bugCategories = new Scorer();
    public static final String FILENAME = "bugrank.txt";
    public static final String ADJUST_FILENAME = "adjustBugrank.txt";

    public BugRanker(@CheckForNull URL u) throws IOException {
        String s;
        if (u == null) {
            return;
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(u.openStream(), "UTF-8"));
        while ((s = in.readLine()) != null) {
            if ((s = s.trim()).length() == 0) continue;
            String[] parts = s.split(" ");
            String rank = parts[0];
            String kind = parts[1];
            String what = parts[2];
            if (kind.equals("BugPattern")) {
                this.bugPatterns.storeAdjustment(what, rank);
                continue;
            }
            if (kind.equals("BugKind")) {
                this.bugKinds.storeAdjustment(what, rank);
                continue;
            }
            if (kind.equals("Category")) {
                this.bugCategories.storeAdjustment(what, rank);
                continue;
            }
            AnalysisContext.logError("Can't parse bug rank " + s);
        }
        Util.closeSilently(in);
    }

    private static int priorityAdjustment(int priority) {
        switch (priority) {
            case 1: {
                return 0;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 5;
            }
        }
        return 10;
    }

    public static int rankBug(BugInstance bug, BugRanker ... rankers) {
        return BugRanker.rankBugPatternWithPriorityAdustment(bug.getBugPattern(), bug.getPriority(), rankers);
    }

    private static int rankBugPatternWithPriorityAdustment(BugPattern bugPattern, int priority, BugRanker ... rankers) {
        int rankBugPattern = BugRanker.rankBugPattern(bugPattern, rankers);
        int priorityAdjustment = BugRanker.priorityAdjustment(priority);
        if (rankBugPattern > 20) {
            return rankBugPattern + priorityAdjustment;
        }
        return Math.min(rankBugPattern + priorityAdjustment, 20);
    }

    private static int rankBugPattern(BugPattern bugPattern, BugRanker ... rankers) {
        String type = bugPattern.getType();
        int rank = 0;
        for (BugRanker b : rankers) {
            if (b == null) continue;
            rank += b.bugPatterns.get(type);
            if (b.bugPatterns.isRelative(type)) continue;
            return rank;
        }
        String kind = bugPattern.getAbbrev();
        for (BugRanker b : rankers) {
            if (b == null) continue;
            rank += b.bugKinds.get(kind);
            if (b.bugKinds.isRelative(kind)) continue;
            return rank;
        }
        String category = bugPattern.getCategory();
        for (BugRanker b : rankers) {
            if (b == null) continue;
            rank += b.bugCategories.get(category);
            if (b.bugCategories.isRelative(category)) continue;
            return rank;
        }
        return 20;
    }

    private static BugRanker getAdjustmentBugRanker() {
        DetectorFactoryCollection factory = DetectorFactoryCollection.instance();
        return factory.getAdjustmentBugRanker();
    }

    private static BugRanker getCoreRanker() {
        DetectorFactoryCollection factory = DetectorFactoryCollection.instance();
        return factory.getCorePlugin().getBugRanker();
    }

    public static int findRank(BugInstance bug) {
        BugRanker coreRanker;
        DetectorFactory detectorFactory = bug.getDetectorFactory();
        if (null == detectorFactory) {
            return BugRanker.findRank(bug.getBugPattern(), bug.getPriority());
        }
        Plugin plugin = detectorFactory.getPlugin();
        BugRanker adjustmentRanker = BugRanker.getAdjustmentBugRanker();
        BugRanker pluginRanker = plugin.getBugRanker();
        if (pluginRanker == (coreRanker = BugRanker.getCoreRanker())) {
            return BugRanker.rankBug(bug, adjustmentRanker, coreRanker);
        }
        return BugRanker.rankBug(bug, adjustmentRanker, pluginRanker, coreRanker);
    }

    public static int findRank(BugPattern pattern, Plugin plugin, int priority) {
        BugRanker coreRanker;
        BugRanker adjustmentRanker = BugRanker.getAdjustmentBugRanker();
        BugRanker pluginRanker = plugin.getBugRanker();
        if (pluginRanker == (coreRanker = BugRanker.getCoreRanker())) {
            return BugRanker.rankBugPatternWithPriorityAdustment(pattern, priority, adjustmentRanker, coreRanker);
        }
        return BugRanker.rankBugPatternWithPriorityAdustment(pattern, priority, adjustmentRanker, pluginRanker, coreRanker);
    }

    public static int findRank(BugPattern pattern, int priority) {
        DetectorFactoryCollection factory = DetectorFactoryCollection.instance();
        Plugin corePlugin = factory.getCorePlugin();
        ArrayList<BugRanker> rankers = new ArrayList<BugRanker>();
        rankers.add(BugRanker.getAdjustmentBugRanker());
        for (Plugin plugin : factory.plugins()) {
            if (plugin == corePlugin) continue;
            rankers.add(plugin.getBugRanker());
        }
        rankers.add(BugRanker.getCoreRanker());
        return BugRanker.rankBugPatternWithPriorityAdustment(pattern, priority, rankers.toArray(new BugRanker[0]));
    }

    public static void trimToMaxRank(BugCollection origCollection, int maxRank) {
        if (maxRank < 20) {
            Iterator<BugInstance> i = origCollection.getCollection().iterator();
            while (i.hasNext()) {
                BugInstance b = i.next();
                if (BugRanker.findRank(b) <= maxRank) continue;
                i.remove();
            }
        }
    }

    static class Scorer {
        private final HashMap<String, Integer> adjustment = new HashMap();
        private final HashSet<String> isRelative = new HashSet();

        Scorer() {
        }

        int get(String key) {
            Integer v = this.adjustment.get(key);
            if (v == null) {
                return 0;
            }
            return v;
        }

        boolean isRelative(String key) {
            return !this.adjustment.containsKey(key) || this.isRelative.contains(key);
        }

        void storeAdjustment(String key, String value) {
            int v = Integer.parseInt(value);
            char firstChar = value.charAt(0);
            this.adjustment.put(key, v);
            if (firstChar == '+' || firstChar == '-') {
                this.isRelative.add(key);
            }
        }
    }
}

