/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugCollectionBugReporter;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.BugRanker;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.DelegatingBugReporter;
import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.ExcludingHashesBugReporter;
import edu.umd.cs.findbugs.FilterBugReporter;
import edu.umd.cs.findbugs.FindBugsAnalysisFeatures;
import edu.umd.cs.findbugs.FirstPassDetector;
import edu.umd.cs.findbugs.IFindBugsEngine;
import edu.umd.cs.findbugs.InterproceduralFirstPassDetector;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.ShowHelp;
import edu.umd.cs.findbugs.TextUICommandLine;
import edu.umd.cs.findbugs.TrainingDetector;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.config.AnalysisFeatureSetting;
import edu.umd.cs.findbugs.config.CommandLine;
import edu.umd.cs.findbugs.config.UserPreferences;
import edu.umd.cs.findbugs.filter.Filter;
import edu.umd.cs.findbugs.filter.FilterException;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.dom4j.DocumentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FindBugs {
    public static final AnalysisFeatureSetting[] MIN_EFFORT = new AnalysisFeatureSetting[]{new AnalysisFeatureSetting(1, true), new AnalysisFeatureSetting(0, false), new AnalysisFeatureSetting(7, true), new AnalysisFeatureSetting(2, false), new AnalysisFeatureSetting(3, true), new AnalysisFeatureSetting(4, false), new AnalysisFeatureSetting(5, false), new AnalysisFeatureSetting(6, false), new AnalysisFeatureSetting(FindBugsAnalysisFeatures.INTERPROCEDURAL_ANALYSIS, false), new AnalysisFeatureSetting(FindBugsAnalysisFeatures.INTERPROCEDURAL_ANALYSIS_OF_REFERENCED_CLASSES, false)};
    public static final AnalysisFeatureSetting[] LESS_EFFORT = new AnalysisFeatureSetting[]{new AnalysisFeatureSetting(1, false), new AnalysisFeatureSetting(0, true), new AnalysisFeatureSetting(7, true), new AnalysisFeatureSetting(2, true), new AnalysisFeatureSetting(3, true), new AnalysisFeatureSetting(4, true), new AnalysisFeatureSetting(5, false), new AnalysisFeatureSetting(6, false), new AnalysisFeatureSetting(FindBugsAnalysisFeatures.INTERPROCEDURAL_ANALYSIS, false), new AnalysisFeatureSetting(FindBugsAnalysisFeatures.INTERPROCEDURAL_ANALYSIS_OF_REFERENCED_CLASSES, false)};
    public static final AnalysisFeatureSetting[] DEFAULT_EFFORT = new AnalysisFeatureSetting[]{new AnalysisFeatureSetting(1, false), new AnalysisFeatureSetting(0, true), new AnalysisFeatureSetting(7, true), new AnalysisFeatureSetting(2, true), new AnalysisFeatureSetting(3, true), new AnalysisFeatureSetting(4, true), new AnalysisFeatureSetting(5, true), new AnalysisFeatureSetting(6, true), new AnalysisFeatureSetting(FindBugsAnalysisFeatures.INTERPROCEDURAL_ANALYSIS, true), new AnalysisFeatureSetting(FindBugsAnalysisFeatures.INTERPROCEDURAL_ANALYSIS_OF_REFERENCED_CLASSES, false)};
    public static final AnalysisFeatureSetting[] MORE_EFFORT = new AnalysisFeatureSetting[]{new AnalysisFeatureSetting(1, false), new AnalysisFeatureSetting(0, true), new AnalysisFeatureSetting(7, true), new AnalysisFeatureSetting(2, true), new AnalysisFeatureSetting(3, true), new AnalysisFeatureSetting(4, true), new AnalysisFeatureSetting(5, true), new AnalysisFeatureSetting(6, true), new AnalysisFeatureSetting(FindBugsAnalysisFeatures.INTERPROCEDURAL_ANALYSIS, true), new AnalysisFeatureSetting(FindBugsAnalysisFeatures.INTERPROCEDURAL_ANALYSIS_OF_REFERENCED_CLASSES, false)};
    public static final AnalysisFeatureSetting[] MAX_EFFORT = new AnalysisFeatureSetting[]{new AnalysisFeatureSetting(1, false), new AnalysisFeatureSetting(0, true), new AnalysisFeatureSetting(7, true), new AnalysisFeatureSetting(2, true), new AnalysisFeatureSetting(3, false), new AnalysisFeatureSetting(4, true), new AnalysisFeatureSetting(5, true), new AnalysisFeatureSetting(6, true), new AnalysisFeatureSetting(FindBugsAnalysisFeatures.INTERPROCEDURAL_ANALYSIS, true), new AnalysisFeatureSetting(FindBugsAnalysisFeatures.INTERPROCEDURAL_ANALYSIS_OF_REFERENCED_CLASSES, true)};
    public static final boolean DEBUG = Boolean.getBoolean("findbugs.debug");
    private static String home = System.getProperty("findbugs.home");
    public static boolean noAnalysis = Boolean.getBoolean("findbugs.noAnalysis");
    public static final Logger LOGGER = Logger.getLogger(FindBugs.class.getPackage().getName());
    public static final Set<String> knownURLProtocolSet;
    public static final long MINIMUM_TIMESTAMP = 1000000000000L;

    public static void setNoAnalysis() {
        noAnalysis = true;
    }

    public static void setHome(String home) {
        FindBugs.home = home;
    }

    public static String getHome() {
        return home;
    }

    public static void configureTrainingDatabases(IFindBugsEngine findBugs) throws IOException {
        if (findBugs.emitTrainingOutput()) {
            String trainingOutputDir = findBugs.getTrainingOutputDir();
            if (!new File(trainingOutputDir).isDirectory()) {
                throw new IOException("Training output directory " + trainingOutputDir + " does not exist");
            }
            AnalysisContext.currentAnalysisContext().setDatabaseOutputDir(trainingOutputDir);
            System.setProperty("findbugs.checkreturn.savetraining", new File(trainingOutputDir, "checkReturn.db").getPath());
        }
        if (findBugs.useTrainingInput()) {
            String trainingInputDir = findBugs.getTrainingInputDir();
            if (!new File(trainingInputDir).isDirectory()) {
                throw new IOException("Training input directory " + trainingInputDir + " does not exist");
            }
            AnalysisContext.currentAnalysisContext().setDatabaseInputDir(trainingInputDir);
            AnalysisContext.currentAnalysisContext().loadInterproceduralDatabases();
            System.setProperty("findbugs.checkreturn.loadtraining", new File(trainingInputDir, "checkReturn.db").getPath());
        } else {
            AnalysisContext.currentAnalysisContext().loadDefaultInterproceduralDatabases();
        }
    }

    public static boolean isDetectorEnabled(IFindBugsEngine findBugs, DetectorFactory factory, int rankThreshold) {
        if (!factory.getPlugin().isEnabled()) {
            return false;
        }
        if (!findBugs.getUserPreferences().isDetectorEnabled(factory)) {
            return false;
        }
        if (!factory.isEnabledForCurrentJRE()) {
            return false;
        }
        if (!AnalysisContext.currentAnalysisContext().getBoolProperty(FindBugsAnalysisFeatures.INTERPROCEDURAL_ANALYSIS) && factory.isDetectorClassSubtypeOf(InterproceduralFirstPassDetector.class)) {
            return false;
        }
        int maxRank = Integer.MAX_VALUE;
        Set<BugPattern> reportedBugPatterns = factory.getReportedBugPatterns();
        boolean isNonReportingDetector = factory.isDetectorClassSubtypeOf(FirstPassDetector.class);
        if (!isNonReportingDetector && !reportedBugPatterns.isEmpty()) {
            for (BugPattern b : reportedBugPatterns) {
                int rank = BugRanker.findRank(b, factory.getPlugin(), 1);
                if (maxRank <= rank) continue;
                maxRank = rank;
            }
            if (maxRank > rankThreshold) {
                return false;
            }
        }
        boolean isTrainingDetector = factory.isDetectorClassSubtypeOf(TrainingDetector.class);
        if (findBugs.emitTrainingOutput()) {
            return isTrainingDetector || isNonReportingDetector;
        }
        return !isTrainingDetector;
    }

    public static Set<String> handleBugCategories(UserPreferences userPreferences, String categories) {
        HashSet<String> categorySet = new HashSet<String>();
        StringTokenizer tok = new StringTokenizer(categories, ",");
        while (tok.hasMoreTokens()) {
            categorySet.add(tok.nextToken());
        }
        return categorySet;
    }

    public static void processCommandLine(TextUICommandLine commandLine, String[] argv, IFindBugsEngine findBugs) throws IOException, FilterException {
        try {
            argv = commandLine.expandOptionFiles(argv, true, true);
        }
        catch (CommandLine.HelpRequestedException e) {
            FindBugs.showHelp(commandLine);
        }
        int argCount = 0;
        try {
            argCount = commandLine.parse(argv);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
            FindBugs.showHelp(commandLine);
        }
        catch (CommandLine.HelpRequestedException e) {
            FindBugs.showHelp(commandLine);
        }
        Project project = commandLine.getProject();
        for (int i = argCount; i < argv.length; ++i) {
            project.addFile(argv[i]);
        }
        commandLine.handleXArgs();
        if (project.getFileCount() == 0) {
            FindBugs.showHelp(commandLine);
        }
        commandLine.configureEngine(findBugs);
    }

    @SuppressWarnings(value={"DM_EXIT"})
    public static void showHelp(TextUICommandLine commandLine) {
        FindBugs.showSynopsis();
        ShowHelp.showGeneralOptions();
        FindBugs.showCommandLineOptions(commandLine);
        System.exit(1);
    }

    @SuppressWarnings(value={"DM_EXIT"})
    public static void runMain(IFindBugsEngine findBugs, TextUICommandLine commandLine) throws IOException {
        try {
            findBugs.execute();
        }
        catch (InterruptedException e) {
            assert (false);
            FindBugs.checkExitCodeFail(commandLine, e);
            throw new RuntimeException(e);
        }
        catch (RuntimeException e) {
            FindBugs.checkExitCodeFail(commandLine, e);
            throw e;
        }
        catch (IOException e) {
            FindBugs.checkExitCodeFail(commandLine, e);
            throw e;
        }
        int bugCount = findBugs.getBugCount();
        int missingClassCount = findBugs.getMissingClassCount();
        int errorCount = findBugs.getErrorCount();
        if (!commandLine.quiet() || commandLine.setExitCode()) {
            if (bugCount > 0) {
                System.err.println("Warnings generated: " + bugCount);
            }
            if (missingClassCount > 0) {
                System.err.println("Missing classes: " + missingClassCount);
            }
            if (errorCount > 0) {
                System.err.println("Analysis errors: " + errorCount);
            }
        }
        if (commandLine.setExitCode()) {
            int exitCode = 0;
            System.err.println("Calculating exit code...");
            if (errorCount > 0) {
                exitCode |= 4;
                System.err.println("Setting 'errors encountered' flag (4)");
            }
            if (missingClassCount > 0) {
                exitCode |= 2;
                System.err.println("Setting 'missing class' flag (2)");
            }
            if (bugCount > 0) {
                exitCode |= 1;
                System.err.println("Setting 'bugs found' flag (1)");
            }
            System.err.println("Exit code set to: " + exitCode);
            System.exit(exitCode);
        }
    }

    private static void checkExitCodeFail(TextUICommandLine commandLine, Exception e) {
        if (commandLine.setExitCode()) {
            e.printStackTrace(System.err);
            System.exit(4);
        }
    }

    public static void showCommandLineOptions() {
        FindBugs.showCommandLineOptions(new TextUICommandLine());
    }

    public static void showCommandLineOptions(TextUICommandLine commandLine) {
        System.out.println("Command line options:");
        commandLine.printUsage(System.out);
    }

    public static void showSynopsis() {
        System.out.println("Usage: findbugs [general options] -textui [command line options...] [jar/zip/class files, directories...]");
    }

    public static void configureFilter(DelegatingBugReporter bugReporter, String filterFileName, boolean include) throws IOException, FilterException {
        Filter filter = new Filter(filterFileName);
        BugReporter origBugReporter = bugReporter.getDelegate();
        FilterBugReporter filterBugReporter = new FilterBugReporter(origBugReporter, filter, include);
        bugReporter.setDelegate(filterBugReporter);
    }

    public static void configureBaselineFilter(DelegatingBugReporter bugReporter, String baselineFileName) throws IOException, DocumentException {
        BugReporter origBugReporter = bugReporter.getDelegate();
        ExcludingHashesBugReporter filterBugReporter = new ExcludingHashesBugReporter(origBugReporter, baselineFileName);
        bugReporter.setDelegate(filterBugReporter);
    }

    public static void configureBugCollection(IFindBugsEngine findBugs) {
        BugReporter realBugReporter = findBugs.getBugReporter().getRealBugReporter();
        if (realBugReporter instanceof BugCollectionBugReporter) {
            long timestamp;
            BugCollectionBugReporter bugCollectionBugReporter = (BugCollectionBugReporter)realBugReporter;
            bugCollectionBugReporter = (BugCollectionBugReporter)realBugReporter;
            bugCollectionBugReporter.getBugCollection().setReleaseName(findBugs.getReleaseName());
            Project project = findBugs.getProject();
            if (project.getProjectName() == null) {
                project.setProjectName(findBugs.getProjectName());
            }
            if (FindBugs.validTimestamp(timestamp = project.getTimestamp())) {
                bugCollectionBugReporter.getBugCollection().setTimestamp(timestamp);
                bugCollectionBugReporter.getBugCollection().getProjectStats().setTimestamp(timestamp);
            }
        }
    }

    public static boolean validTimestamp(long timestamp) {
        return timestamp > 1000000000000L;
    }

    static {
        LOGGER.setLevel(Level.WARNING);
        knownURLProtocolSet = new HashSet<String>();
        knownURLProtocolSet.add("file");
        knownURLProtocolSet.add("http");
        knownURLProtocolSet.add("https");
        knownURLProtocolSet.add("jar");
    }
}

