/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.JavaVersionException;
import edu.umd.cs.findbugs.SystemProperties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaVersion {
    private static final Pattern PATTERN = Pattern.compile("^(\\d+)\\.(\\d+)(\\..*)?$");
    private final int major;
    private final int minor;
    private final String rest;
    private static JavaVersion runtimeVersion;
    public static final JavaVersion JAVA_1_5;

    public JavaVersion(String versionString) throws JavaVersionException {
        Matcher matcher = PATTERN.matcher(versionString);
        if (!matcher.matches()) {
            throw new JavaVersionException("Could not parse Java version string: " + versionString);
        }
        try {
            this.major = Integer.parseInt(matcher.group(1));
            this.minor = Integer.parseInt(matcher.group(2));
            this.rest = matcher.group(3) != null ? matcher.group(3) : "";
        }
        catch (NumberFormatException e) {
            throw new JavaVersionException("Could not parse Java Version string: " + versionString, e);
        }
    }

    public JavaVersion(int major, int minor) {
        this.major = major;
        this.minor = minor;
        this.rest = "";
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public String getRest() {
        return this.rest;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.major);
        buf.append('.');
        buf.append(this.minor);
        if (this.rest != null) {
            buf.append(this.rest);
        }
        return buf.toString();
    }

    public static JavaVersion getRuntimeVersion() {
        return runtimeVersion;
    }

    public boolean isSameOrNewerThan(JavaVersion other) {
        return this.major > other.major || this.major == other.major && this.minor >= other.minor;
    }

    static {
        try {
            runtimeVersion = new JavaVersion(SystemProperties.getProperty("java.version"));
        }
        catch (JavaVersionException e) {
            System.err.println("Warning: Unknown version of Java");
            runtimeVersion = new JavaVersion(1, 0);
            e.printStackTrace();
        }
        JAVA_1_5 = new JavaVersion(1, 5);
    }
}

