/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.XMethod;

public class ProgramPoint {
    public final XMethod method;
    public final int pc;

    public ProgramPoint(BytecodeScanningDetector v) {
        this.method = v.getXMethod();
        this.pc = v.getPC();
    }

    public MethodAnnotation getMethodAnnotation() {
        return MethodAnnotation.fromXMethod(this.method);
    }

    public SourceLineAnnotation getSourceLineAnnotation() {
        return SourceLineAnnotation.fromVisitedInstruction(this.method.getMethodDescriptor(), this.pc);
    }

    public String toString() {
        return this.method.toString() + ":" + this.pc;
    }
}

