/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.CategoryFilteringBugReporter;
import edu.umd.cs.findbugs.ClassScreener;
import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.EmacsBugReporter;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.FindBugsCommandLine;
import edu.umd.cs.findbugs.HTMLBugReporter;
import edu.umd.cs.findbugs.I18N;
import edu.umd.cs.findbugs.IFindBugsEngine;
import edu.umd.cs.findbugs.IFindBugsEngine2;
import edu.umd.cs.findbugs.Plugin;
import edu.umd.cs.findbugs.PrintingBugReporter;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SortingBugReporter;
import edu.umd.cs.findbugs.TextUIBugReporter;
import edu.umd.cs.findbugs.TextUIProgressCallback;
import edu.umd.cs.findbugs.XDocsBugReporter;
import edu.umd.cs.findbugs.XMLBugReporter;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import edu.umd.cs.findbugs.config.UserPreferences;
import edu.umd.cs.findbugs.filter.FilterException;
import edu.umd.cs.findbugs.util.Util;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.dom4j.DocumentException;

public class TextUICommandLine
extends FindBugsCommandLine {
    private static final int PRINTING_REPORTER = 0;
    private static final int SORTING_REPORTER = 1;
    private static final int XML_REPORTER = 2;
    private static final int EMACS_REPORTER = 3;
    private static final int HTML_REPORTER = 4;
    private static final int XDOCS_REPORTER = 5;
    private int bugReporterType = 0;
    private boolean relaxedReportingMode = false;
    private boolean useLongBugCodes = false;
    private boolean showProgress = false;
    private boolean xmlMinimal = false;
    private boolean xmlWithMessages = false;
    private boolean xmlWithAbridgedMessages = false;
    private String stylesheet = null;
    private boolean quiet = false;
    private ClassScreener classScreener = new ClassScreener();
    private List<String> includeFilterFile = new LinkedList<String>();
    private List<String> excludeFilterFile = new LinkedList<String>();
    private List<String> excludeBugFile = new LinkedList<String>();
    private boolean setExitCode = false;
    private boolean noClassOk = false;
    private int priorityThreshold = 2;
    private int rankThreshold = 20;
    private PrintStream outputStream = null;
    private Set<String> bugCategorySet = null;
    private UserPreferences userPreferences;
    private String trainingOutputDir;
    private String trainingInputDir;
    private String releaseName = "";
    private String projectName = "";
    private String sourceInfoFile = null;
    private boolean xargs = false;
    private boolean scanNestedArchives = true;
    private boolean applySuppression;

    public TextUICommandLine() {
        this.addSwitch("-showPlugins", "show list of available detector plugins");
        this.startOptionGroup("Output options:");
        this.addSwitch("-timestampNow", "set timestamp of results to be current time");
        this.addSwitch("-quiet", "suppress error messages");
        this.addSwitch("-longBugCodes", "report long bug codes");
        this.addSwitch("-progress", "display progress in terminal window");
        this.addOption("-release", "release name", "set the release name of the analyzed application");
        this.addSwitch("-experimental", "report all warnings including experimental bug patterns");
        this.addSwitch("-low", "report all warnings");
        this.addSwitch("-medium", "report only medium and high priority warnings [default]");
        this.addSwitch("-high", "report only high priority warnings");
        this.addOption("-maxRank", "rank", "only report issues with a bug rank at least as scary as that provided");
        this.addSwitch("-sortByClass", "sort warnings by class");
        this.addSwitchWithOptionalExtraPart("-xml", "withMessages", "XML output (optionally with messages)");
        this.addSwitch("-xdocs", "xdoc XML output to use with Apache Maven");
        this.addSwitchWithOptionalExtraPart("-html", "stylesheet", "Generate HTML output (default stylesheet is default.xsl)");
        this.addSwitch("-emacs", "Use emacs reporting format");
        this.addSwitch("-relaxed", "Relaxed reporting mode (more false positives!)");
        this.addSwitchWithOptionalExtraPart("-train", "outputDir", "Save training data (experimental); output dir defaults to '.'");
        this.addSwitchWithOptionalExtraPart("-useTraining", "inputDir", "Use training data (experimental); input dir defaults to '.'");
        this.addOption("-sourceInfo", "filename", "Specify source info file (line numbers for fields/classes)");
        this.addOption("-projectName", "project name", "Descriptive name of project");
        this.addOption("-outputFile", "filename", "Save output in named file");
        this.addOption("-output", "filename", "Save output in named file");
        this.makeOptionUnlisted("-outputFile");
        this.addSwitchWithOptionalExtraPart("-nested", "true|false", "analyze nested jar/zip archives (default=true)");
        this.startOptionGroup("Output filtering options:");
        this.addOption("-bugCategories", "cat1[,cat2...]", "only report bugs in given categories");
        this.addOption("-onlyAnalyze", "classes/packages", "only analyze given classes and packages; end with .* to indicate classes in a package, .- to indicate a package prefix");
        this.addOption("-excludeBugs", "baseline bugs", "exclude bugs that are also reported in the baseline xml output");
        this.addOption("-exclude", "filter file", "exclude bugs matching given filter");
        this.addOption("-include", "filter file", "include only bugs matching given filter");
        this.addSwitch("-applySuppression", "Exclude any bugs that match suppression filter loaded from fbp file");
        this.startOptionGroup("Detector (visitor) configuration options:");
        this.addOption("-visitors", "v1[,v2...]", "run only named visitors");
        this.addOption("-omitVisitors", "v1[,v2...]", "omit named visitors");
        this.addOption("-chooseVisitors", "+v1,-v2,...", "selectively enable/disable detectors");
        this.addOption("-choosePlugins", "+p1,-p2,...", "selectively enable/disable plugins");
        this.addOption("-adjustPriority", "v1=(raise|lower)[,...]", "raise/lower priority of warnings for given visitor(s)");
        this.startOptionGroup("Project configuration options:");
        this.addOption("-auxclasspath", "classpath", "set aux classpath for analysis");
        this.addSwitch("-auxclasspathFromInput", "read aux classpath from standard input");
        this.addOption("-sourcepath", "source path", "set source path for analyzed classes");
        this.addSwitch("-exitcode", "set exit code of process");
        this.addSwitch("-noClassOk", "output empty warning file if no classes are specified");
        this.addSwitch("-xargs", "get list of classfiles/jarfiles from standard input rather than command line");
        this.addOption("-cloud", "id", "set cloud id");
        this.addOption("-cloudProperty", "key=value", "set cloud property");
    }

    public Project getProject() {
        return this.project;
    }

    public boolean getXargs() {
        return this.xargs;
    }

    public boolean setExitCode() {
        return this.setExitCode;
    }

    public boolean noClassOk() {
        return this.noClassOk;
    }

    public boolean quiet() {
        return this.quiet;
    }

    public boolean applySuppression() {
        return this.applySuppression;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SuppressWarnings(value={"DM_EXIT"})
    protected void handleOption(String option, String optionExtraPart) {
        if (option.equals("-showPlugins")) {
            System.out.println("Available plugins:");
            int count = 0;
            Iterator<Plugin> i = DetectorFactoryCollection.instance().pluginIterator();
            while (i.hasNext()) {
                Plugin plugin = i.next();
                System.out.println("  " + plugin.getPluginId() + " (default: " + (plugin.isEnabled() ? "enabled" : "disabled") + ")");
                if (plugin.getShortDescription() != null) {
                    System.out.println("    Description: " + plugin.getShortDescription());
                }
                if (plugin.getProvider() != null) {
                    System.out.println("    Provider: " + plugin.getProvider());
                }
                if (plugin.getWebsite() != null) {
                    System.out.println("    Website: " + plugin.getWebsite());
                }
                ++count;
            }
            if (count == 0) {
                System.out.println("  No plugins are available (FindBugs installed incorrectly?)");
            }
            System.exit(0);
            return;
        } else if (option.equals("-experimental")) {
            this.priorityThreshold = 4;
            return;
        } else if (option.equals("-longBugCodes")) {
            this.useLongBugCodes = true;
            return;
        } else if (option.equals("-progress")) {
            this.showProgress = true;
            return;
        } else if (option.equals("-timestampNow")) {
            this.project.setTimestamp(System.currentTimeMillis());
            return;
        } else if (option.equals("-low")) {
            this.priorityThreshold = 3;
            return;
        } else if (option.equals("-medium")) {
            this.priorityThreshold = 2;
            return;
        } else if (option.equals("-high")) {
            this.priorityThreshold = 1;
            return;
        } else if (option.equals("-sortByClass")) {
            this.bugReporterType = 1;
            return;
        } else if (option.equals("-xml")) {
            this.bugReporterType = 2;
            if (optionExtraPart.equals("")) return;
            if (optionExtraPart.equals("withMessages")) {
                this.xmlWithMessages = true;
                return;
            } else if (optionExtraPart.equals("withAbridgedMessages")) {
                this.xmlWithMessages = true;
                this.xmlWithAbridgedMessages = true;
                return;
            } else {
                if (!optionExtraPart.equals("minimal")) throw new IllegalArgumentException("Unknown option: -xml:" + optionExtraPart);
                this.xmlWithMessages = false;
                this.xmlMinimal = true;
            }
            return;
        } else if (option.equals("-emacs")) {
            this.bugReporterType = 3;
            return;
        } else if (option.equals("-relaxed")) {
            this.relaxedReportingMode = true;
            return;
        } else if (option.equals("-train")) {
            this.trainingOutputDir = !optionExtraPart.equals("") ? optionExtraPart : ".";
            return;
        } else if (option.equals("-useTraining")) {
            this.trainingInputDir = !optionExtraPart.equals("") ? optionExtraPart : ".";
            return;
        } else if (option.equals("-html")) {
            this.bugReporterType = 4;
            this.stylesheet = !optionExtraPart.equals("") ? optionExtraPart : "default.xsl";
            return;
        } else if (option.equals("-xdocs")) {
            this.bugReporterType = 5;
            return;
        } else if (option.equals("-applySuppression")) {
            this.applySuppression = true;
            return;
        } else if (option.equals("-quiet")) {
            this.quiet = true;
            return;
        } else if (option.equals("-nested")) {
            this.scanNestedArchives = optionExtraPart.equals("") || Boolean.valueOf(optionExtraPart) != false;
            return;
        } else if (option.equals("-exitcode")) {
            this.setExitCode = true;
            return;
        } else if (option.equals("-auxclasspathFromInput")) {
            try {
                String s;
                BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
                while ((s = in.readLine()) != null) {
                    this.addAuxClassPathEntries(s);
                }
                return;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else if (option.equals("-noClassOk")) {
            this.noClassOk = true;
            return;
        } else if (option.equals("-xargs")) {
            this.xargs = true;
            return;
        } else {
            super.handleOption(option, optionExtraPart);
        }
    }

    @SuppressWarnings(value={"DM_EXIT"})
    protected void handleOptionWithArgument(String option, String argument) throws IOException {
        if (option.equals("-outputFile") || option.equals("-output")) {
            File outputFile = new File(argument);
            String extension = Util.getFileExtension(outputFile);
            if (this.bugReporterType == 0 && (extension.equals("xml") || extension.equals("fba"))) {
                this.bugReporterType = 2;
            }
            try {
                this.outputStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(outputFile)));
            }
            catch (IOException e) {
                System.err.println("Couldn't open " + outputFile + " for output: " + e.toString());
                System.exit(1);
            }
        } else if (option.equals("-cloud")) {
            this.project.setCloudId(argument);
        } else if (option.equals("-cloudProperty")) {
            int e = argument.indexOf(61);
            if (e == -1) {
                throw new IllegalArgumentException("Bad cloud property: " + argument);
            }
            String key = argument.substring(0, e);
            String value = argument.substring(e + 1);
            this.project.getCloudProperties().setProperty(key, value);
        } else if (option.equals("-maxRank")) {
            this.rankThreshold = Integer.parseInt(argument);
        } else if (option.equals("-projectName")) {
            this.projectName = argument;
        } else if (option.equals("-release")) {
            this.releaseName = argument;
        } else if (option.equals("-sourceInfo")) {
            this.sourceInfoFile = argument;
        } else if (option.equals("-visitors") || option.equals("-omitVisitors")) {
            boolean omit = option.equals("-omitVisitors");
            if (!omit) {
                this.getUserPreferences().enableAllDetectors(false);
            }
            StringTokenizer tok = new StringTokenizer(argument, ",");
            while (tok.hasMoreTokens()) {
                String visitorName = tok.nextToken().trim();
                DetectorFactory factory = DetectorFactoryCollection.instance().getFactory(visitorName);
                if (factory == null) {
                    throw new IllegalArgumentException("Unknown detector: " + visitorName);
                }
                this.getUserPreferences().enableDetector(factory, !omit);
            }
        } else if (option.equals("-chooseVisitors")) {
            this.choose(argument, "Detector choices", new Chooser(){

                public void choose(boolean enabled, String what) {
                    DetectorFactory factory = DetectorFactoryCollection.instance().getFactory(what);
                    if (factory == null) {
                        throw new IllegalArgumentException("Unknown detector: " + what);
                    }
                    if (FindBugs.DEBUG) {
                        System.err.println("Detector " + factory.getShortName() + " " + (enabled ? "enabled" : "disabled") + ", userPreferences=" + System.identityHashCode(TextUICommandLine.this.getUserPreferences()));
                    }
                    TextUICommandLine.this.getUserPreferences().enableDetector(factory, enabled);
                }
            });
        } else if (option.equals("-choosePlugins")) {
            this.choose(argument, "Plugin choices", new Chooser(){

                public void choose(boolean enabled, String what) {
                    Plugin plugin = DetectorFactoryCollection.instance().getPluginById(what);
                    if (plugin == null) {
                        throw new IllegalArgumentException("Unknown plugin: " + what);
                    }
                    plugin.setEnabled(enabled);
                }
            });
        } else if (option.equals("-adjustPriority")) {
            StringTokenizer tok = new StringTokenizer(argument, ",");
            while (tok.hasMoreTokens()) {
                int adjustmentAmount;
                String token = tok.nextToken();
                int eq = token.indexOf(61);
                if (eq < 0) {
                    throw new IllegalArgumentException("Illegal priority adjustment: " + token);
                }
                String adjustmentTarget = token.substring(0, eq);
                String adjustment = token.substring(eq + 1);
                if (adjustment.equals("raise")) {
                    adjustmentAmount = -1;
                } else if (adjustment.equals("lower")) {
                    adjustmentAmount = 1;
                } else if (adjustment.equals("suppress")) {
                    adjustmentAmount = 100;
                } else {
                    throw new IllegalArgumentException("Illegal priority adjustment value: " + adjustment);
                }
                DetectorFactory factory = DetectorFactoryCollection.instance().getFactory(adjustmentTarget);
                if (factory != null) {
                    factory.setPriorityAdjustment(adjustmentAmount);
                    continue;
                }
                I18N i18n = I18N.instance();
                BugPattern pattern = i18n.lookupBugPattern(adjustmentTarget);
                if (pattern == null) {
                    throw new IllegalArgumentException("Unknown detector: " + adjustmentTarget);
                }
                pattern.adjustPriority(adjustmentAmount);
            }
        } else if (option.equals("-bugCategories")) {
            this.bugCategorySet = FindBugs.handleBugCategories(this.getUserPreferences(), argument);
        } else if (option.equals("-onlyAnalyze")) {
            StringTokenizer tok = new StringTokenizer(argument, ",");
            while (tok.hasMoreTokens()) {
                String item = tok.nextToken();
                if (item.endsWith(".-")) {
                    this.classScreener.addAllowedPrefix(item.substring(0, item.length() - 1));
                    continue;
                }
                if (item.endsWith(".*")) {
                    this.classScreener.addAllowedPackage(item.substring(0, item.length() - 1));
                    continue;
                }
                this.classScreener.addAllowedClass(item);
            }
        } else if (option.equals("-exclude")) {
            this.excludeFilterFile.add(argument);
        } else if (option.equals("-excludeBugs")) {
            this.excludeBugFile.add(argument);
        } else if (option.equals("-include")) {
            this.includeFilterFile.add(argument);
        } else if (option.equals("-auxclasspath")) {
            this.addAuxClassPathEntries(argument);
        } else if (option.equals("-sourcepath")) {
            StringTokenizer tok = new StringTokenizer(argument, File.pathSeparator);
            while (tok.hasMoreTokens()) {
                this.project.addSourceDir(new File(tok.nextToken()).getAbsolutePath());
            }
        } else {
            super.handleOptionWithArgument(option, argument);
        }
    }

    private void addAuxClassPathEntries(String argument) {
        StringTokenizer tok = new StringTokenizer(argument, File.pathSeparator);
        while (tok.hasMoreTokens()) {
            this.project.addAuxClasspathEntry(tok.nextToken());
        }
    }

    private void choose(String argument, String desc, Chooser chooser) {
        StringTokenizer tok = new StringTokenizer(argument, ",");
        while (tok.hasMoreTokens()) {
            String what = tok.nextToken().trim();
            if (!what.startsWith("+") && !what.startsWith("-")) {
                throw new IllegalArgumentException(desc + " must start with " + "\"+\" or \"-\" (saw " + what + ")");
            }
            boolean enabled = what.startsWith("+");
            chooser.choose(enabled, what.substring(1));
        }
    }

    public void configureEngine(IFindBugsEngine findBugs) throws IOException, FilterException {
        TextUIBugReporter textuiBugReporter;
        DetectorFactoryCollection.instance().ensureLoaded();
        findBugs.setDetectorFactoryCollection(DetectorFactoryCollection.instance());
        switch (this.bugReporterType) {
            case 0: {
                textuiBugReporter = new PrintingBugReporter();
                break;
            }
            case 1: {
                textuiBugReporter = new SortingBugReporter();
                break;
            }
            case 2: {
                XMLBugReporter xmlBugReporter = new XMLBugReporter(this.project);
                xmlBugReporter.setAddMessages(this.xmlWithMessages);
                xmlBugReporter.setMinimalXML(this.xmlMinimal);
                textuiBugReporter = xmlBugReporter;
                break;
            }
            case 3: {
                textuiBugReporter = new EmacsBugReporter();
                break;
            }
            case 4: {
                textuiBugReporter = new HTMLBugReporter(this.project, this.stylesheet);
                break;
            }
            case 5: {
                textuiBugReporter = new XDocsBugReporter(this.project);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (this.quiet) {
            textuiBugReporter.setErrorVerbosity(0);
        }
        textuiBugReporter.setPriorityThreshold(this.priorityThreshold);
        textuiBugReporter.setRankThreshold(this.rankThreshold);
        textuiBugReporter.setUseLongBugCodes(this.useLongBugCodes);
        if (findBugs instanceof IFindBugsEngine2) {
            ((IFindBugsEngine2)findBugs).setRankThreshold(this.rankThreshold);
        }
        if (this.outputStream != null) {
            textuiBugReporter.setOutputStream(this.outputStream);
        }
        BugReporter bugReporter = textuiBugReporter;
        if (this.bugCategorySet != null) {
            bugReporter = new CategoryFilteringBugReporter(bugReporter, this.bugCategorySet);
        }
        findBugs.setBugReporter(bugReporter);
        findBugs.setProject(this.project);
        if (this.showProgress) {
            findBugs.setProgressCallback(new TextUIProgressCallback(System.out));
        }
        findBugs.setUserPreferences(this.getUserPreferences());
        for (String s : this.excludeBugFile) {
            try {
                findBugs.excludeBaselineBugs(s);
            }
            catch (DocumentException e) {
                throw new IOException("Unable to read " + this.excludeBugFile + ":" + e.getMessage());
            }
        }
        for (String s : this.includeFilterFile) {
            findBugs.addFilter(s, true);
        }
        for (String s : this.excludeFilterFile) {
            findBugs.addFilter(s, false);
        }
        findBugs.setClassScreener(this.classScreener);
        findBugs.setRelaxedReportingMode(this.relaxedReportingMode);
        findBugs.setAbridgedMessages(this.xmlWithAbridgedMessages);
        if (this.trainingOutputDir != null) {
            findBugs.enableTrainingOutput(this.trainingOutputDir);
        }
        if (this.trainingInputDir != null) {
            findBugs.enableTrainingInput(this.trainingInputDir);
        }
        if (this.sourceInfoFile != null) {
            findBugs.setSourceInfoFile(this.sourceInfoFile);
        }
        findBugs.setAnalysisFeatureSettings(this.settingList);
        findBugs.setReleaseName(this.releaseName);
        findBugs.setProjectName(this.projectName);
        findBugs.setScanNestedArchives(this.scanNestedArchives);
        findBugs.setNoClassOk(this.noClassOk);
        if (this.applySuppression) {
            findBugs.setApplySuppression(true);
        }
        findBugs.finishSettings();
    }

    public void handleXArgs() throws IOException {
        if (this.getXargs()) {
            String s;
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            while ((s = in.readLine()) != null) {
                this.project.addFile(s);
            }
        }
    }

    private UserPreferences getUserPreferences() {
        if (this.userPreferences == null) {
            this.userPreferences = UserPreferences.createDefaultUserPreferences();
        }
        return this.userPreferences;
    }

    private static interface Chooser {
        public void choose(boolean var1, String var2);
    }
}

