/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import java.util.Map;
import java.util.TreeMap;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PutfieldScanner {
    public static Map<Integer, OpcodeStack.Item> getPutfieldsFor(JavaClass theClass, Method method, XField field) {
        Scanner scanner = new Scanner(theClass, method, field);
        scanner.execute();
        return scanner.putfields;
    }

    static class Scanner
    extends OpcodeStackDetector {
        Map<Integer, OpcodeStack.Item> putfields = new TreeMap<Integer, OpcodeStack.Item>();
        final JavaClass theClass;
        final Method targetMethod;
        final XField targetField;

        public Scanner(JavaClass theClass, Method targetMethod, XField target) {
            this.theClass = theClass;
            this.targetMethod = targetMethod;
            this.targetField = target;
        }

        public void sawOpcode(int seen) {
            if (seen != 181) {
                return;
            }
            XField xFieldOperand = this.getXFieldOperand();
            if (xFieldOperand != null && xFieldOperand.equals(this.targetField) && this.stack.getStackItem(1).getRegisterNumber() == 0) {
                this.putfields.put(this.getPC(), new OpcodeStack.Item(this.stack.getStackItem(0)));
            }
        }

        public void visitJavaClass(JavaClass obj) {
            this.setupVisitorForClass(obj);
            this.getConstantPool().accept((Visitor)this);
            this.doVisitMethod(this.targetMethod);
        }

        public void execute() {
            this.theClass.accept((Visitor)this);
        }
    }
}

