/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.npe2;

import edu.umd.cs.findbugs.ba.npe2.NullnessValue;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import java.util.BitSet;

public class DefinitelyNullSet {
    private BitSet contents = new BitSet();
    private int numValueNumbers;

    public DefinitelyNullSet(int numValueNumbers) {
        this.numValueNumbers = numValueNumbers;
    }

    public NullnessValue getNulllessValue(ValueNumber valueNumber) {
        return this.getNullnessValue(valueNumber.getNumber());
    }

    private NullnessValue getNullnessValue(int vn) {
        int flags = 0;
        int start = this.getStartIndex(vn);
        for (int i = 0; i < 4; ++i) {
            if (!this.contents.get(start + i)) continue;
            flags |= 1 << i;
        }
        return NullnessValue.fromFlags(flags);
    }

    public void setNullnessValue(ValueNumber valueNumber, NullnessValue nullnessValue) {
        int flags = nullnessValue.getFlags();
        int start = this.getStartIndex(valueNumber.getNumber());
        for (int i = 0; i < 4; ++i) {
            this.contents.set(start + i, (flags & 1 << i) != 0);
        }
    }

    public void clear() {
        this.contents.clear();
    }

    public void setTop() {
        this.contents.clear();
        this.contents.set(this.lastUsedBit());
    }

    public boolean isTop() {
        return this.contents.get(this.lastUsedBit());
    }

    public void setBottom() {
        this.contents.clear();
        this.contents.set(this.lastUsedBit() + 1);
    }

    public boolean isBottom() {
        return this.contents.get(this.lastUsedBit() + 1);
    }

    public boolean isValid() {
        return !this.isTop() && !this.isBottom();
    }

    public void makeSameAs(DefinitelyNullSet other) {
        this.contents.clear();
        this.contents.or(other.contents);
    }

    public void mergeWith(DefinitelyNullSet other) {
        if (this.isBottom() || other.isTop()) {
            return;
        }
        if (this.isTop() || other.isBottom()) {
            this.makeSameAs(other);
            return;
        }
        this.contents.and(other.contents);
    }

    public BitSet getAssignedNullLocationSet(ValueNumber vn) {
        throw new UnsupportedOperationException();
    }

    public void addAssignedNullLocation(int valueNumber, int locationNumber) {
    }

    public void clearAssignNullLocations(int valueNumber) {
    }

    private int getStartIndex(int vn) {
        return vn * 16;
    }

    private int lastUsedBit() {
        return this.numValueNumbers * 4;
    }

    private int topBit() {
        return this.lastUsedBit();
    }

    private int bottomBit() {
        return this.lastUsedBit() + 1;
    }

    public int hashCode() {
        return this.contents.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DefinitelyNullSet other = (DefinitelyNullSet)obj;
        return this.contents.equals(other.contents);
    }

    public String toString() {
        if (this.isTop()) {
            return "[TOP]";
        }
        if (this.isBottom()) {
            return "[BOTTOM]";
        }
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        buf.append("{");
        for (int i = 0; i < this.numValueNumbers; ++i) {
            NullnessValue val = this.getNullnessValue(i);
            if (!val.isDefinitelyNull() && !val.isDefinitelyNotNull()) continue;
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            buf.append(i);
            buf.append("->");
            buf.append(val.toString());
        }
        buf.append("}");
        return buf.toString();
    }
}

