/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.bcel;

import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.OpcodeStack;
import org.apache.bcel.classfile.Code;

public abstract class OpcodeStackDetector
extends BytecodeScanningDetector {
    protected OpcodeStack stack;

    public void visitCode(Code obj) {
        if (!this.shouldVisitCode(obj)) {
            return;
        }
        this.stack = new OpcodeStack();
        this.stack.resetForMethodEntry(this);
        super.visitCode(obj);
        this.stack = null;
    }

    public boolean beforeOpcode(int seen) {
        this.stack.precomputation(this);
        this.stack.mergeJumps(this);
        return !this.stack.isTop();
    }

    public void afterOpcode(int seen) {
        this.stack.sawOpcode(this, seen);
    }

    public abstract void sawOpcode(int var1);

    public static abstract class WithCustomJumpInfo
    extends OpcodeStackDetector {
        public abstract OpcodeStack.JumpInfo customJumpInfo();
    }
}

