/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.analysis;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.classfile.analysis.AnnotatedObject;
import edu.umd.cs.findbugs.classfile.analysis.AnnotationValue;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import edu.umd.cs.findbugs.internalAnnotations.SlashedClassName;
import edu.umd.cs.findbugs.util.Util;
import java.lang.annotation.ElementType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodInfo
extends MethodDescriptor
implements XMethod,
AnnotatedObject {
    public static final MethodInfo[] EMPTY_ARRAY = new MethodInfo[0];
    final int accessFlags;
    final int methodCallCount;
    final boolean usesConcurrency;
    final boolean isStub;
    final String methodSourceSignature;
    @CheckForNull
    final String[] exceptions;
    Map<ClassDescriptor, AnnotationValue> methodAnnotations;
    Map<Integer, Map<ClassDescriptor, AnnotationValue>> methodParameterAnnotations;
    static IdentityHashMap<MethodInfo, Void> unconditionalThrowers = new IdentityHashMap();
    static IdentityHashMap<MethodInfo, Void> unsupportedMethods = new IdentityHashMap();
    static IdentityHashMap<MethodInfo, MethodDescriptor> accessMethodFor = new IdentityHashMap();

    public static MethodInfo[] newArray(int sz) {
        if (sz == 0) {
            return EMPTY_ARRAY;
        }
        return new MethodInfo[sz];
    }

    MethodInfo(@SlashedClassName String className, String methodName, String methodSignature, String methodSourceSignature, int accessFlags, boolean isUnconditionalThrower, boolean isUnsupported, boolean usesConcurrency, boolean isStub, int methodCallCount, @CheckForNull String[] exceptions, @CheckForNull MethodDescriptor accessMethodFor, Map<ClassDescriptor, AnnotationValue> methodAnnotations, Map<Integer, Map<ClassDescriptor, AnnotationValue>> methodParameterAnnotations) {
        super(className, methodName, methodSignature, (accessFlags & 8) != 0);
        this.accessFlags = accessFlags;
        this.exceptions = exceptions;
        if (exceptions != null) {
            for (int i = 0; i < exceptions.length; ++i) {
                exceptions[i] = DescriptorFactory.canonicalizeString(exceptions[i]);
            }
        }
        this.methodSourceSignature = DescriptorFactory.canonicalizeString(methodSourceSignature);
        this.methodAnnotations = Util.immutableMap(methodAnnotations);
        this.methodParameterAnnotations = Util.immutableMap(methodParameterAnnotations);
        if (isUnconditionalThrower) {
            unconditionalThrowers.put(this, null);
        }
        if (isUnsupported) {
            unsupportedMethods.put(this, null);
        }
        this.usesConcurrency = usesConcurrency;
        this.isStub = isStub;
        this.methodCallCount = methodCallCount;
    }

    @Override
    @CheckForNull
    public String[] getThrownExceptions() {
        return this.exceptions;
    }

    @Override
    public boolean isUnconditionalThrower() {
        return unconditionalThrowers.containsKey(this);
    }

    @Override
    public boolean isUnsupported() {
        return unsupportedMethods.containsKey(this);
    }

    @Override
    public int getNumParams() {
        return new SignatureParser(this.getSignature()).getNumParameters();
    }

    public int getMethodCallCount() {
        return this.methodCallCount;
    }

    private boolean checkFlag(int flag) {
        return (this.accessFlags & flag) != 0;
    }

    @Override
    public boolean isNative() {
        return this.checkFlag(256);
    }

    @Override
    public boolean isAbstract() {
        return this.checkFlag(1024);
    }

    @Override
    public boolean isSynchronized() {
        return this.checkFlag(32);
    }

    @Override
    public boolean isReturnTypeReferenceType() {
        SignatureParser parser = new SignatureParser(this.getSignature());
        String returnTypeSig = parser.getReturnTypeSignature();
        return SignatureParser.isReferenceType(returnTypeSig);
    }

    @Override
    @DottedClassName
    public String getClassName() {
        return this.getClassDescriptor().toDottedClassName();
    }

    @Override
    @DottedClassName
    public String getPackageName() {
        return this.getClassDescriptor().getPackageName();
    }

    @Override
    public String getSourceSignature() {
        return this.methodSourceSignature;
    }

    @Override
    public int compareTo(Object rhs) {
        if (rhs instanceof MethodDescriptor) {
            return super.compareTo((MethodDescriptor)rhs);
        }
        if (rhs instanceof XMethod) {
            return XFactory.compare(this, (XMethod)rhs);
        }
        throw new ClassCastException("Can't compare a " + this.getClass().getName() + " to a " + rhs.getClass().getName());
    }

    @Override
    public int getAccessFlags() {
        return this.accessFlags;
    }

    @Override
    public boolean isFinal() {
        return this.checkFlag(16);
    }

    @Override
    public boolean isPrivate() {
        return this.checkFlag(2);
    }

    @Override
    public boolean isDeprecated() {
        return this.checkFlag(131072);
    }

    @Override
    public boolean isProtected() {
        return this.checkFlag(4);
    }

    @Override
    public boolean isPublic() {
        return this.checkFlag(1);
    }

    @Override
    public boolean isSynthetic() {
        return this.checkFlag(4096);
    }

    @Override
    public boolean isResolved() {
        return true;
    }

    @Override
    public Collection<ClassDescriptor> getParameterAnnotationDescriptors(int param) {
        Map<ClassDescriptor, AnnotationValue> map = this.methodParameterAnnotations.get(param);
        if (map == null) {
            return Collections.emptySet();
        }
        return map.keySet();
    }

    @Override
    @Nullable
    public AnnotationValue getParameterAnnotation(int param, ClassDescriptor desc) {
        Map<ClassDescriptor, AnnotationValue> map = this.methodParameterAnnotations.get(param);
        if (map == null) {
            return null;
        }
        return map.get(desc);
    }

    @Override
    public Collection<AnnotationValue> getParameterAnnotations(int param) {
        Map<ClassDescriptor, AnnotationValue> map = this.methodParameterAnnotations.get(param);
        if (map == null) {
            return Collections.emptySet();
        }
        return map.values();
    }

    @Override
    public Collection<ClassDescriptor> getAnnotationDescriptors() {
        return this.methodAnnotations.keySet();
    }

    @Override
    public AnnotationValue getAnnotation(ClassDescriptor desc) {
        return this.methodAnnotations.get(desc);
    }

    @Override
    public Collection<AnnotationValue> getAnnotations() {
        return this.methodAnnotations.values();
    }

    @Override
    public void addAnnotation(AnnotationValue annotationValue) {
        HashMap<ClassDescriptor, AnnotationValue> updatedAnnotations = new HashMap<ClassDescriptor, AnnotationValue>(this.methodAnnotations);
        updatedAnnotations.put(annotationValue.getAnnotationClass(), annotationValue);
        this.methodAnnotations = updatedAnnotations;
    }

    @Override
    public void addParameterAnnotation(int param, AnnotationValue annotationValue) {
        HashMap<Integer, Map<ClassDescriptor, AnnotationValue>> updatedAnnotations = new HashMap<Integer, Map<ClassDescriptor, AnnotationValue>>(this.methodParameterAnnotations);
        Map<ClassDescriptor, AnnotationValue> paramMap = updatedAnnotations.get(param);
        if (paramMap == null) {
            paramMap = new HashMap<ClassDescriptor, AnnotationValue>();
            updatedAnnotations.put(param, paramMap);
        }
        paramMap.put(annotationValue.getAnnotationClass(), annotationValue);
        this.methodParameterAnnotations = updatedAnnotations;
    }

    @Override
    public MethodDescriptor getMethodDescriptor() {
        return this;
    }

    @Override
    public ElementType getElementType() {
        if (this.getName().equals("<init>")) {
            return ElementType.CONSTRUCTOR;
        }
        return ElementType.METHOD;
    }

    @Override
    @CheckForNull
    public AnnotatedObject getContainingScope() {
        try {
            return Global.getAnalysisCache().getClassAnalysis(XClass.class, this.getClassDescriptor());
        }
        catch (CheckedAnalysisException e) {
            return null;
        }
    }

    @Override
    public boolean isVarArgs() {
        return this.checkFlag(128);
    }

    @Override
    public boolean usesConcurrency() {
        return this.usesConcurrency;
    }

    @Override
    public boolean isStub() {
        return this.isStub;
    }

    @CheckForNull
    public MethodDescriptor getAccessMethodFor() {
        return accessMethodFor.get(this);
    }

    @Override
    public XMethod bridgeFrom() {
        return AnalysisContext.currentAnalysisContext().getBridgeFrom(this);
    }

    @Override
    public XMethod bridgeTo() {
        return AnalysisContext.currentAnalysisContext().getBridgeTo(this);
    }

    public static class Builder {
        int accessFlags;
        @SlashedClassName
        final String className;
        final String methodName;
        final String methodSignature;
        String[] exceptions;
        String methodSourceSignature;
        boolean isUnconditionalThrower;
        boolean isUnsupported;
        boolean usesConcurrency;
        boolean isStub;
        int methodCallCount;
        MethodDescriptor accessMethodFor;
        final Map<ClassDescriptor, AnnotationValue> methodAnnotations = new HashMap<ClassDescriptor, AnnotationValue>(4);
        final Map<Integer, Map<ClassDescriptor, AnnotationValue>> methodParameterAnnotations = new HashMap<Integer, Map<ClassDescriptor, AnnotationValue>>(4);

        public Builder(@SlashedClassName String className, String methodName, String methodSignature, int accessFlags) {
            this.className = className;
            this.methodName = methodName;
            this.methodSignature = methodSignature;
            this.accessFlags = accessFlags;
        }

        public void setAccessMethodFor(String owner, String name, String sig, boolean isStatic) {
            this.accessMethodFor = new MethodDescriptor(owner, name, sig, isStatic);
        }

        public void setSourceSignature(String methodSourceSignature) {
            this.methodSourceSignature = methodSourceSignature;
        }

        public void setUsesConcurrency() {
            this.usesConcurrency = true;
        }

        public void setIsStub() {
            this.isStub = true;
        }

        public void setThrownExceptions(String[] exceptions) {
            this.exceptions = exceptions;
        }

        public void setAccessFlags(int accessFlags) {
            this.accessFlags = accessFlags;
        }

        public void addAccessFlags(int accessFlags) {
            this.accessFlags |= accessFlags;
        }

        public void addAnnotation(String name, AnnotationValue value) {
            ClassDescriptor annotationClass = DescriptorFactory.createClassDescriptorFromSignature(name);
            this.methodAnnotations.put(annotationClass, value);
        }

        public void addParameterAnnotation(int parameter, String name, AnnotationValue value) {
            ClassDescriptor annotationClass = DescriptorFactory.createClassDescriptorFromSignature(name);
            Map<ClassDescriptor, AnnotationValue> map = this.methodParameterAnnotations.get(parameter);
            if (map == null) {
                map = new HashMap<ClassDescriptor, AnnotationValue>();
                this.methodParameterAnnotations.put(parameter, map);
            }
            map.put(annotationClass, value);
        }

        public MethodInfo build() {
            return new MethodInfo(this.className, this.methodName, this.methodSignature, this.methodSourceSignature, this.accessFlags, this.isUnconditionalThrower, this.isUnsupported, this.usesConcurrency, this.isStub, this.methodCallCount, this.exceptions, this.accessMethodFor, this.methodAnnotations, this.methodParameterAnnotations);
        }

        public void setIsUnconditionalThrower() {
            this.isUnconditionalThrower = true;
        }

        public void setUnsupported() {
            this.isUnsupported = true;
        }

        public void setNumberMethodCalls(int methodCallCount) {
            this.methodCallCount = methodCallCount;
        }
    }
}

