/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.engine.bcel;

import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.InnerClassAccess;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.vna.LoadedFieldSet;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.classfile.engine.bcel.AnalysisFactory;
import java.util.BitSet;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.MethodGen;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadedFieldSetFactory
extends AnalysisFactory<LoadedFieldSet> {
    static final BitSet fieldInstructionOpcodeSet = new BitSet();

    public LoadedFieldSetFactory() {
        super("loaded field set factory", LoadedFieldSet.class);
    }

    @Override
    public LoadedFieldSet analyze(IAnalysisCache analysisCache, MethodDescriptor descriptor) throws CheckedAnalysisException {
        MethodGen methodGen = this.getMethodGen(analysisCache, descriptor);
        if (methodGen == null) {
            return null;
        }
        InstructionList il = methodGen.getInstructionList();
        LoadedFieldSet loadedFieldSet = new LoadedFieldSet(methodGen);
        ConstantPoolGen cpg = this.getConstantPoolGen(analysisCache, descriptor.getClassDescriptor());
        for (InstructionHandle handle = il.getStart(); handle != null; handle = handle.getNext()) {
            Instruction ins = handle.getInstruction();
            short opcode = ins.getOpcode();
            try {
                if (opcode == 184) {
                    InnerClassAccess access;
                    INVOKESTATIC inv = (INVOKESTATIC)ins;
                    if (!Hierarchy.isInnerClassAccess(inv, cpg) || (access = Hierarchy.getInnerClassAccess(inv, cpg)) == null) continue;
                    if (access.isLoad()) {
                        loadedFieldSet.addLoad(handle, access.getField());
                        continue;
                    }
                    loadedFieldSet.addStore(handle, access.getField());
                    continue;
                }
                if (!fieldInstructionOpcodeSet.get(opcode)) continue;
                boolean isLoad = opcode == 180 || opcode == 178;
                XField field = Hierarchy.findXField((FieldInstruction)ins, cpg);
                if (field == null) continue;
                if (isLoad) {
                    loadedFieldSet.addLoad(handle, field);
                    continue;
                }
                loadedFieldSet.addStore(handle, field);
                continue;
            }
            catch (ClassNotFoundException e) {
                AnalysisContext.currentAnalysisContext().getLookupFailureCallback().reportMissingClass(e);
            }
        }
        return loadedFieldSet;
    }

    static {
        fieldInstructionOpcodeSet.set(180);
        fieldInstructionOpcodeSet.set(181);
        fieldInstructionOpcodeSet.set(178);
        fieldInstructionOpcodeSet.set(179);
    }
}

