/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.cloud;

import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugDesignation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.PropertyBundle;
import edu.umd.cs.findbugs.cloud.AbstractCloud;
import edu.umd.cs.findbugs.cloud.Cloud;
import edu.umd.cs.findbugs.cloud.CloudPlugin;
import edu.umd.cs.findbugs.cloud.username.NoNameLookup;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugCollectionStorageCloud
extends AbstractCloud {
    private static CloudPlugin getFallbackPlugin() {
        return new CloudPlugin("fallback local cloud", BugCollectionStorageCloud.class.getClassLoader(), BugCollectionStorageCloud.class, NoNameLookup.class, new PropertyBundle(), "no description", "no details");
    }

    public BugCollectionStorageCloud(CloudPlugin plugin, BugCollection bc, Properties properties) {
        super(plugin, bc, properties);
        this.setSigninState(Cloud.SigninState.NO_SIGNIN_REQUIRED);
    }

    BugCollectionStorageCloud(BugCollection bc) {
        this(BugCollectionStorageCloud.getFallbackPlugin(), bc, new Properties());
    }

    @Override
    public boolean initialize() {
        try {
            return super.initialize();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void waitUntilIssueDataDownloaded() {
    }

    @Override
    public void initiateCommunication() {
    }

    @Override
    public Cloud.Mode getMode() {
        return Cloud.Mode.COMMUNAL;
    }

    @Override
    public String getUser() {
        return null;
    }

    @Override
    public Cloud.UserDesignation getUserDesignation(BugInstance b) {
        BugDesignation bd = b.getUserDesignation();
        if (bd == null) {
            return Cloud.UserDesignation.UNCLASSIFIED;
        }
        return Cloud.UserDesignation.valueOf(bd.getDesignationKey());
    }

    @Override
    public String getUserEvaluation(BugInstance b) {
        BugDesignation bd = b.getUserDesignation();
        if (bd == null) {
            return "";
        }
        return bd.getAnnotationText();
    }

    @Override
    public long getUserTimestamp(BugInstance b) {
        BugDesignation bd = b.getUserDesignation();
        if (bd == null) {
            return Long.MAX_VALUE;
        }
        return bd.getTimestamp();
    }

    @Override
    public void setMode(Cloud.Mode m) {
    }

    @Override
    public void bugsPopulated() {
    }

    @Override
    public void setSaveSignInInformation(boolean save) {
    }

    @Override
    public boolean isSavingSignInInformationEnabled() {
        return false;
    }

    @Override
    public void signIn() {
    }

    @Override
    public void signOut() {
    }

    @Override
    public boolean availableForInitialization() {
        return true;
    }

    @Override
    public void storeUserAnnotation(BugInstance bugInstance) {
    }

    @Override
    public void bugFiled(BugInstance b, Object bugLink) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BugDesignation getPrimaryDesignation(BugInstance b) {
        return b.getUserDesignation();
    }

    @Override
    protected Iterable<BugDesignation> getLatestDesignationFromEachUser(BugInstance bd) {
        return Collections.emptyList();
    }

    @Override
    public Collection<String> getProjects(String className) {
        return Collections.emptyList();
    }

    @Override
    public String getCloudName() {
        return "local storage cloud";
    }

    @Override
    public int getNumberReviewers(BugInstance b) {
        return b.getXmlProps().getReviewCount();
    }

    @Override
    public Cloud.UserDesignation getConsensusDesignation(BugInstance b) {
        String consensus = b.getXmlProps().getConsensus();
        if (consensus == null) {
            return Cloud.UserDesignation.UNCLASSIFIED;
        }
        try {
            return Cloud.UserDesignation.valueOf(consensus);
        }
        catch (IllegalArgumentException e) {
            return Cloud.UserDesignation.UNCLASSIFIED;
        }
    }

    @Override
    public long getFirstSeen(BugInstance b) {
        long computed = super.getFirstSeen(b);
        Date fromXml = b.getXmlProps().getFirstSeen();
        if (fromXml == null) {
            return computed;
        }
        long fromXmlTime = fromXml.getTime();
        if (computed == 0L && fromXmlTime > 0L) {
            return fromXmlTime;
        }
        if (fromXmlTime == 0L && computed > 0L) {
            return computed;
        }
        return Math.min(fromXmlTime, computed);
    }
}

