/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.cloud;

import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugDesignation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.cloud.CloudPlugin;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.annotation.CheckForNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Cloud {
    public CloudPlugin getPlugin();

    public BugCollection getBugCollection();

    public String getStatusMsg();

    public void addListener(CloudListener var1);

    public void removeListener(CloudListener var1);

    public void addStatusListener(CloudStatusListener var1);

    public void removeStatusListener(CloudStatusListener var1);

    public boolean availableForInitialization();

    public boolean initialize() throws IOException;

    public void waitUntilIssueDataDownloaded();

    public void bugsPopulated();

    public void initiateCommunication();

    public void shutdown();

    public Mode getMode();

    public void setMode(Mode var1);

    public boolean getIWillFix(BugInstance var1);

    public boolean supportsSourceLinks();

    public String getSourceLinkToolTip(@CheckForNull BugInstance var1);

    public URL getSourceLink(BugInstance var1);

    public String getUser();

    public SigninState getSigninState();

    public void setSaveSignInInformation(boolean var1);

    public boolean isSavingSignInInformationEnabled();

    public void signIn() throws IOException;

    public void signOut();

    public boolean supportsBugLinks();

    public BugFilingStatus getBugLinkStatus(BugInstance var1);

    public boolean getWillNotBeFixed(BugInstance var1);

    public boolean getBugIsUnassigned(BugInstance var1);

    public URL getBugLink(BugInstance var1);

    public URL fileBug(BugInstance var1);

    public void bugFiled(BugInstance var1, @CheckForNull Object var2);

    public boolean supportsCloudReports();

    public String getCloudReport(BugInstance var1);

    public boolean supportsClaims();

    @CheckForNull
    public String claimedBy(BugInstance var1);

    public boolean claim(BugInstance var1);

    public long getUserTimestamp(BugInstance var1);

    public Date getUserDate(BugInstance var1);

    public BugDesignation getPrimaryDesignation(BugInstance var1);

    public UserDesignation getUserDesignation(BugInstance var1);

    public String getUserEvaluation(BugInstance var1);

    public double getClassificationScore(BugInstance var1);

    public double getClassificationVariance(BugInstance var1);

    public double getClassificationDisagreement(BugInstance var1);

    public double getPortionObsoleteClassifications(BugInstance var1);

    public int getNumberReviewers(BugInstance var1);

    public Set<String> getReviewers(BugInstance var1);

    public long getFirstSeen(BugInstance var1);

    public UserDesignation getConsensusDesignation(BugInstance var1);

    public boolean overallClassificationIsNotAProblem(BugInstance var1);

    public void storeUserAnnotation(BugInstance var1);

    public boolean canStoreUserAnnotation(BugInstance var1);

    public void printCloudSummary(PrintWriter var1, Iterable<BugInstance> var2, String[] var3);

    public boolean supportsCloudSummaries();

    public Collection<String> getProjects(String var1);

    public String getCloudName();

    public String getBugLinkType(BugInstance var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BugFilingStatus {
        FILE_BUG(SystemProperties.getProperty("findbugs.filebug.label", "File bug")){

            public boolean bugIsFiled() {
                return false;
            }
        }
        ,
        FILE_AGAIN("File again"),
        BUG_PENDING("Bug pending"){

            public boolean linkEnabled() {
                return false;
            }
        }
        ,
        VIEW_BUG(SystemProperties.getProperty("findbugs.viewbug.label", "View bug")),
        NA(""){

            public boolean linkEnabled() {
                return false;
            }

            public boolean bugIsFiled() {
                return false;
            }
        };

        final String displayName;

        public boolean bugIsFiled() {
            return true;
        }

        public boolean linkEnabled() {
            return true;
        }

        private BugFilingStatus(String name) {
            this.displayName = name;
        }

        public String toString() {
            return this.displayName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        COMMUNAL,
        VOTING,
        SECRET;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UserDesignation {
        UNCLASSIFIED,
        NEEDS_STUDY,
        BAD_ANALYSIS,
        NOT_A_BUG,
        MOSTLY_HARMLESS,
        SHOULD_FIX,
        MUST_FIX,
        I_WILL_FIX,
        OBSOLETE_CODE;


        public int score() {
            switch (this) {
                case BAD_ANALYSIS: {
                    return -3;
                }
                case NOT_A_BUG: 
                case OBSOLETE_CODE: {
                    return -2;
                }
                case MOSTLY_HARMLESS: {
                    return -1;
                }
                case SHOULD_FIX: {
                    return 1;
                }
                case MUST_FIX: 
                case I_WILL_FIX: {
                    return 2;
                }
            }
            return 0;
        }

        public boolean nonVoting() {
            return this == OBSOLETE_CODE || this == NEEDS_STUDY || this == UNCLASSIFIED;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SigninState {
        NO_SIGNIN_REQUIRED,
        UNAUTHENTICATED,
        SIGNING_IN,
        SIGNED_IN,
        SIGNIN_FAILED,
        SIGNED_OUT;

        static final ResourceBundle names;

        public String toString() {
            String value = names.getString(this.name());
            if (value != null) {
                return value.trim();
            }
            return this.name();
        }

        static {
            names = ResourceBundle.getBundle(Cloud.class.getName(), Locale.getDefault());
        }
    }

    public static interface CloudStatusListener {
        public void handleIssueDataDownloadedEvent();

        public void handleStateChange(SigninState var1, SigninState var2);
    }

    public static interface CloudListener {
        public void issueUpdated(BugInstance var1);

        public void statusUpdated();
    }
}

