/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.cloud;

import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.IGuiCallback;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.cloud.BugCollectionStorageCloud;
import edu.umd.cs.findbugs.cloud.Cloud;
import edu.umd.cs.findbugs.cloud.CloudPlugin;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloudFactory {
    private static final String FINDBUGS_NAMELOOKUP_CLASSNAME = "findbugs.namelookup.classname";
    private static final String FINDBUGS_NAMELOOKUP_REQUIRED = "findbugs.namelookup.required";
    public static boolean DEBUG = SystemProperties.getBoolean("findbugs.cloud.debug", false);
    public static String DEFAULT_CLOUD = SystemProperties.getProperty("findbugs.cloud.default");
    private static final Logger LOGGER = Logger.getLogger(CloudFactory.class.getName());
    static Map<String, CloudPlugin> registeredClouds = new LinkedHashMap<String, CloudPlugin>();

    public static Cloud createCloudWithoutInitializing(BugCollection bc) {
        CloudPlugin plugin = null;
        String cloudId = bc.getProject().getCloudId();
        if (cloudId != null) {
            plugin = registeredClouds.get(cloudId);
        }
        boolean usedDefaultCloud = false;
        if (plugin == null) {
            if (DEFAULT_CLOUD != null) {
                LOGGER.log(Level.FINE, "Trying default cloud " + DEFAULT_CLOUD);
            }
            cloudId = DEFAULT_CLOUD;
            plugin = registeredClouds.get(cloudId);
            usedDefaultCloud = true;
            if (plugin == null) {
                LOGGER.log(Level.FINE, "default cloud " + DEFAULT_CLOUD + " not registered");
                return CloudFactory.getPlainCloud(bc);
            }
        }
        LOGGER.log(Level.FINE, "Using cloud plugin " + plugin.getId());
        try {
            Class<? extends Cloud> cloudClass = plugin.getCloudClass();
            Properties properties = bc.getProject().getCloudProperties();
            Constructor<? extends Cloud> constructor = cloudClass.getConstructor(CloudPlugin.class, BugCollection.class, Properties.class);
            Cloud cloud = constructor.newInstance(plugin, bc, properties);
            if (DEBUG) {
                bc.getProject().getGuiCallback().showMessageDialog("constructed " + cloud.getClass().getName());
            }
            LOGGER.log(Level.FINE, "constructed cloud plugin " + plugin.getId());
            return cloud;
        }
        catch (Exception e) {
            if (DEBUG) {
                bc.getProject().getGuiCallback().showMessageDialog("failed " + e.getMessage() + e.getClass().getName());
            }
            LOGGER.log(Level.WARNING, "Could not load cloud plugin " + plugin, e);
            if (SystemProperties.getBoolean("findbugs.failIfUnableToConnectToCloud")) {
                System.exit(1);
            }
            return CloudFactory.getPlainCloud(bc);
        }
    }

    public static void initializeCloud(BugCollection bc, Cloud cloud) throws IOException {
        IGuiCallback callback = bc.getProject().getGuiCallback();
        if (cloud.availableForInitialization()) {
            if (DEBUG) {
                callback.showMessageDialog("attempting to initialize " + cloud.getClass().getName());
            }
            if (cloud.initialize()) {
                if (DEBUG) {
                    callback.showMessageDialog("initialized " + cloud.getClass().getName());
                }
                return;
            }
            callback.showMessageDialog("Unable to connect to " + cloud.getCloudName());
        }
    }

    public static Cloud getPlainCloud(BugCollection bc) {
        BugCollectionStorageCloud cloud = new BugCollectionStorageCloud(bc);
        if (cloud.initialize()) {
            return cloud;
        }
        throw new IllegalStateException("Unable to initialize plain cloud");
    }

    public static Map<String, CloudPlugin> getRegisteredClouds() {
        return Collections.unmodifiableMap(registeredClouds);
    }

    public static void registerCloud(CloudPlugin cloudPlugin, boolean enabled) {
        LOGGER.log(Level.FINE, "Registering " + cloudPlugin.getId());
        if (enabled) {
            registeredClouds.put(cloudPlugin.getId(), cloudPlugin);
        }
    }
}

